#define _POSIX_SOURCE

#include <sys/select.h>
#include <prototypes/inet_proto.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <c_utilities.h>
#include <errno.h>

#define bzero(s, len)             memset((char *)(s), 0, len)

int errno;

main (argc, argv)
int    argc;
char   *argv [];

{
 short port_no;                    /* port to listen on - arg 1 */
 int   ka_timer;                   /* timer for keep alive - arg 2 */
 short delay;                      /* delay between echos in seconds - arg 3 */
 short lingertime = 0;             /* linger time in seconds - arg 4 */

 struct sockaddr_in serv_addr;     /* used to bind to IP address and port */
 struct sockaddr_in cli_addr;      /* holds address of remote from accept */
 int    clilen;                    /* holds length of cli_addr structure) */
 int    nfds;                      /* max sock FD value, used in select */
 fd_set fdsetR;                    /* set of FDs to be tested by select */

 struct timeval timeout;           /* holds select timeout value */
 struct linger  linger1;           /* linger structure */
 int nodelay = 1;                  /* flag to control no delay setting */
 int reuse = 1;                    /* flag to control address reuse */
 int fcntl_flags;                  /* holds flags for fcntl function
                                      used to set non-blocking mode */
#define BUFFERLEN 100              /* how many bytes can we process at once */
#define MAXSOCKS 10                /* how many sockets can be handled */
 int socks [MAXSOCKS];             /* array holding the socket FDs */
 char peer [MAXSOCKS][16];         /* array holding string containing IP
                                      address of remote peer for socker */
 char echostring [MAXSOCKS][BUFFERLEN]; /* array holding characters to be
                                           echoed */
 int echostringlen [MAXSOCKS];     /* array holding number of character in
                                      echostring array */
 int socketWaitingToConnect [MAXSOCKS];  /* indicates if socket is waiting */
                                         /* for connection to complete */
 int oldechostringlen;             /* olds previous length of the string 
                                      this is a temporary used for printing
                                      so we only need 1 */
 short nSocks = 0;                 /* last used index in socks arrays */
 short maxSockFD = 0;              /* maximum value of socket FD */
 short freeSocks = 0;              /* a free entry in the socks array or
                                      nSocks. Will be < nSocks if a client
                                      has closed a connection */
 short socksSelected;              /* number of sockets that select indicates
                                      are ready */
 short socksProcessed;             /* number of sockets that have been
                                      processed in current iteration */
 int recvBytes, sendBytes;         /* number of bytes received and sent */
 char msg [103];                   /* temporary space for a string */
 char *peer_x;                     /* temporary space to hold the string
                                      containing peer;s IP address */
 short i, j, x, y;                 /* loop counters and temporaries */



 if (argc == 5)                    /* process the arguments. This is very */
    {                              /* simplestic argument processing, all */
    port_no = atoi (argv [1]);     /* arguments are required and are */
    ka_timer = atoi (argv [2]);    /* positional. But then again this */
    delay = atoi (argv [3]);       /* example is not about argument */
    lingertime = atoi (argv [4]);  /* processing */
    }
 else                              /* if we don't have all the arguments */
    {                              /* print out a usage message */
    printf ("\nUsage: stcp_echo <port_number> <keep_alive timer> <echo delay in seconds> <linger seconds>\n");
    printf ("\t\tkeep_alive on/off  -- 0 off, anything else on\n");
    printf ("\t\tminimum delay 1, maximum delay is 15\n");
    printf ("\t\ta negative value for linger will cause it not to be set, 0 is valid\n");
    exit (-1);
    }

/* sanity check the values of the arguments. The max and min values are based
   on my view or reality, yours may be different
*/
 if (delay > 15)
    {
    printf ("%d is just too long a delay adjusting to 5\n", delay);
    delay = 5;
    }
 if (delay < 1) 
    {
    delay = 1;
    }
 if ((ka_timer < 120) && (ka_timer != 0))
    {
    printf ("%d is just too short a keep alive value adjusting to 120\n", ka_timer);
    ka_timer = 120;
    }
 if (ka_timer > 14400)
    {
    printf ("%d is just too large a keep alive value adjusting to 14400\n", ka_timer);
    ka_timer = 14400;
    }

 if (port_no < 1024)
    printf ("\nIf you are not privileged using port numbers below 1024 will not work\n\n");

/* Leting you know what argument values will actually be used */

 printf ("echo %d %d %d %d\n\n", port_no, ka_timer, delay, lingertime);

/* load the timeout struction based on the input delay value. This will be used
   by select. */

 timeout.tv_sec = delay;
 timeout.tv_usec = 0;

/* create a stream socket */
 if ((socks [0] = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
    perror ("echo: can't open stream socket");
    exit (errno);
    }

/* we now have 1 socket - note that nSocks is 1 greater than the index into
   the array. Obviously the maximum socket FD value is that socket */

 nSocks = 1;
 maxSockFD = socks [0];

/* set a bunch of sock options on what will become the listening socket.
   all these options will be inherited by the sockets created when a
   connection comes in and an accept is done */

/* Set SO_REUSEADDR so that I do not have to wait for an old socket in 
   TIMEWAIT state to be cleaned up before starting another server */

 if (setsockopt (socks [0], SOL_SOCKET, SO_REUSEADDR, (char *) &reuse, sizeof (reuse)) < 0)
   {
   perror ("echo: Error setting reuseaddr");
   exit (errno);
   }

/* set the linger timer if its greater than -1. */

 if (lingertime > -1)
    {
    linger1.l_onoff = 1;
    linger1.l_linger = lingertime;
    if (setsockopt (socks [0], SOL_SOCKET, SO_LINGER, (char *) &linger1, sizeof (linger1)) < 0)
       {
       perror ("echo: Error setting linger");
       exit (errno);
       }
    }

/* turn keep alive on so any connections that are left hanging can be cleaned
   up eventually. */

 if (ka_timer != 0)
    {
    linger1.l_onoff = 1;
    linger1.l_linger = ka_timer;
    if (setsockopt (socks [0], SOL_SOCKET, SO_KEEPALIVE, (char *) &linger1, sizeof (linger1)) < 0)
      {
      perror ("echo: Error setting keepalive");
      exit (errno);
      }
    }

/* turn on no delay. This turns off the nagel algorithm so that we can send
   multiple small (less than MSS) packets without waiting for an ACK. */

 if (setsockopt (socks [0], IPPROTO_TCP, TCP_NODELAY, (char *) &nodelay, sizeof (nodelay)) < 0)
    {
    perror ("echo: Error setting nodelay");
    exit (errno);
    }

/* build a sockaddr structure holding the address we will bind to. The IP
   address is INADDR_ANY meaning we will listen on all active IP addresses */

 bzero ( (char *) &serv_addr, sizeof (serv_addr));
 serv_addr.sin_family        = AF_INET;
 serv_addr.sin_addr.s_addr   = htonl (INADDR_ANY);
 serv_addr.sin_port          = htons (port_no);

/* now bind to the address and port */

 if (bind (socks [0], (struct sockaddr *) &serv_addr, sizeof (serv_addr)) < 0)
    {
    perror ("echo: can't bind local address");
    exit (errno);
    }

/* set non-blocking mode on the socket. At the moment doing a get and ORing
   in the O_NDELAY value is probably overkill since the only flag supported 
   at this time is O_NDELAY. But things may change in the future so (as was
   explained to be in painful detail with graphic images of bits crashing
   togther) its best to do things right. */

 fcntl_flags = fcntl(socks [0], F_GETFL, 0);
 if (fcntl_flags < 0)
    {
    perror ("echo: could not get the current fcntl flags for listening socket");
    exit (errno);
    }

 fcntl_flags = fcntl_flags | O_NDELAY;

 if (fcntl(socks [0], F_SETFL, fcntl_flags) < 0)
    {
    perror ("echo: could not set non blocking IO for listening socket");
    exit (errno);
    }

/* listen for connections with a backlog of 5 */

 listen (socks [0], 5);

/* begining of main loop through the code, now things get complicated */

again:

/* reset the file descriptor array for select. This has to be done every time
   you go through select since select will modify this array

   Also find an array index that represents a socket that is not in use. The
   loop will find the last index instead of the first but it really doesn't matter */

FD_ZERO (&fdsetR);
freeSocks = nSocks;
FD_SET (socks [0], &fdsetR);
for (i = 0; i < nSocks; i++)
    {
    if (socks [i] != 0)
       FD_SET (socks [i], &fdsetR);
    else
       freeSocks = i;
    }

/* Calculate the nfds value as the highest socket number plus 1. This is
   needed by select. maxSockFD is maintained when the accept is done */

nfds = maxSockFD + 1;

/* Do the select. We are only interested in reading and a timeout so the
   write and exception arguments are null */

socksSelected = select (nfds, &fdsetR, (fd_set *) 0, (fd_set *) 0, &timeout);

if (socksSelected < 0)
   {
   perror ("echo: select returned with an error, give up at this point");
   exit (errno);
   }

/* if select returns a value greater than 0 it represents the number of
   sockets ready (for reading in this case).  */

socksProcessed = 0;
if (socksSelected > 0)
   {
   if (FD_ISSET (socks [0], &fdsetR))     /* the listening socket has */
      {                                   /* special handling */
      socksProcessed++;
      if (freeSocks < MAXSOCKS)           /* if there a free element in the */
         {                                /* socks array */
         clilen = sizeof (cli_addr);      /* this could be outside the loop */
                                          /* but I use it here so here it is */
         socks [freeSocks] = accept (socks [0], (struct sockaddr *) &cli_addr, &clilen);
         if (socks [freeSocks] < 0)       /* if accept returns < 0 we have */
            perror ("echo: accept error"); /* an error */
         else
            {
            peer_x = inet_ntoa (cli_addr.sin_addr);  /* get peers address */
            strcpy (&peer [freeSocks][0], peer_x);   /* and report it */
            printf ("Connection from %s\n", &peer [freeSocks][0]);
   
            strcpy (&echostring [freeSocks][0], ""); /* initial related */
            echostringlen [freeSocks] = 0;           /* arrays */
   
            if (socks [freeSocks] > maxSockFD)       /* update maxSoxFD */
                maxSockFD = socks [freeSocks];       /* if needed */

/* non-bocking IO is not the same as TCP_NODELAY, it also is not inherited
   from listening socket so it must be done for every accepted socket */

            fcntl_flags = fcntl(socks [freeSocks], F_GETFL, 0);
            if (fcntl_flags < 0)
               {
               perror ("echo: could not get the current fcntl flags for accepted socket");
               exit (errno);
               }
            
            fcntl_flags = fcntl_flags | O_NDELAY;;
 
            if (fcntl(socks [freeSocks], F_SETFL, fcntl_flags) < 0)
               {
               perror ("echo: could not set non blocking IO for accepted socket");
               exit (errno);
               }

            if (freeSocks == nSocks)    /* increment last used entry in */
               nSocks++;                /* socks array if necessary */

            socketWaitingToConnect [freeSocks] = 0;
            strcpy (msg, "Welcome to Noah's Echooooooo Serverrrrrrr\n");
            sendBytes = send (socks [freeSocks], msg, strlen (msg), 0);
            if (sendBytes < 0)          /* problem sending greeting */
               {
               if (errno == ENOTCONN)  /* not connected yet */
                  {
                  printf ("Error (1) = %d\n", errno);
                  socketWaitingToConnect [freeSocks] = 1;
                  }
               else                     /* some other error, close down socket */
                  {
                  perror ("echo: Unexpected error while sending greeting string");
                  close (socks [freeSocks]);
                  socks [freeSocks] = 0;
                  peer [freeSocks][0] = 0x0;
                  echostring [freeSocks][0] = 0x0;
                  echostringlen [freeSocks] = 0;
                  socketWaitingToConnect [freeSocks] = 0;
                  } /* if (errno == ENOTCONN) -- else */
               } /* if (sendBytes < 0) */
            } /* if (socks [freeSocks] < 0) -- else */
         } /* if (freeSocks < MAXSOCKS) */
      } /* if (FD_ISSET (socks [0], &fdsetR)) */

/* this is the loop for all the sockets. */

   for (j = 1; j < nSocks; j++)
       { 

/* we have processed all the sockets that select indicated were ready we
   can skip the rest of the code and go back to select */

       if (socksSelected == socksProcessed)
          goto again;

       if (FD_ISSET (socks [j], &fdsetR))  /* if this socket is ready for */
          {                                /* reading */
          socksProcessed++;                /* count it */
          if (echostringlen [j] > 2)       /* "remove" ending \n\r that */
              echostringlen [j] = echostringlen [j] - 2; /* were added */

/* receive bytes based on the number of bytes left in buffer. There will
   be bytes left in the buffer if we have not completed echoing the last
   string sent to us. We also need to leave room for the \n\r\0 that will be
   added to the end of the buffer. If there are more bytes in the receive
   queue then can fit in the buffer the next time select is called it will
   immediately indicate that the socket is ready for reading */

          recvBytes = recv (socks [j], &echostring [j][echostringlen [j]], BUFFERLEN - echostringlen [j] - 3, 0);
          if (recvBytes == -1)
             {                     /* error during recv, if really connected */
                                   /* clean up the socks and related arrays */
                                   /* if we are not really connected just */
                                   /* forget about it */
             if (errno != ENOTCONN)/* I am not sure if we will ever get EIO */
                {                  /* here since select would have to have  */
                                   /* indicated that this socket is ready */
                                   /* to read but if we get it - ignore it*/
                sprintf (msg, "echo: Unexpected error while receiving on socket connected to %s", &peer [j][0]);
                perror (msg);
                close (socks [j]);
                socks [j] = 0;
                peer [j][0] = 0x0;
                echostring [j][0] = 0x0;
                echostringlen [j] = 0;
                socketWaitingToConnect [j] = 0;
                 } /* if (errno != ENOTCONN) */
             } /* if (recvBytes == -1) */
          else                 /* no error on recv */
             {
             if (recvBytes == 0)  /* indicates connection was closed by peer */
                {
                printf ("echo: closing connection for %s\n", &peer [j][0]);
                if (close (socks [j]) < 0)  /* close our socket */
                   {
                   sprintf (msg, "echo: error closing socket connected to %s", &peer [j][0]);
                   perror (msg);
                   }
                socks [j] = 0;     /* and clean up arrays */
                peer [j][0] = 0x0;
                echostring [j][0] = 0x0;
                echostringlen [j] = 0;
                socketWaitingToConnect [j] = 0;
                } /* if (recvBytes == 0) */
             else       /* we actually had bytes to read and we read them */
                {
                if (recvBytes > 0)
                   {
                   socketWaitingToConnect [j] = 0; /* we are connected */

/* adjust the number of bytes we have in the buffer to include what was just 
   read. Then add a \n\r\0 to it. The \n\r is needed so that when we echo
   the bytes we move the cursor down to the next line. Some clients, like
   telnet will not do that for the user. Without the \n\r the output becomes
   very strange. The \0 is needed so that %s in printf works correctly */

                   oldechostringlen = echostringlen [j];
                   echostringlen [j] = echostringlen [j] + recvBytes;
                   echostring [j][echostringlen [j]] = '\n';
                   echostring [j][echostringlen [j]+1] = '\r';
                   echostring [j][echostringlen [j]+2] = 0x0;
                   echostringlen [j] = echostringlen [j] + 2;

/* now print the string but start from what was the end of the buffer so we 
   print only the bytes that were just received. */

                   printf ("echo: received from %s: %d bytes %s", &peer [j][0], recvBytes, &echostring [j][oldechostringlen]);

/* now send the entire buffer, any old bytes and the new bytes */

                   sendBytes = send (socks [j], &echostring [j][0], echostringlen [j], 0);

/* if we didn't send all the bytes we had some kind of problem. Ideally at this
   point I could loop and try to send again or take some kind of exception
   problem. It is not strictly speaking an error. I choose just to report it.
   ALWAYS CHECK and take appropriate action, never assume that all characters
   were sent */

                   if (sendBytes != echostringlen [j])
                      printf ("echo: problem sending echo string to %s only %d out of %d characters sent\n", &peer [j][0], sendBytes, echostringlen [j]);
                   else

/* If all characters were sent OK echo that and then cut the buffer in half
   and remeber the last half for further echoing */

                      printf ("echo: echoing to %s: %d bytes %s", &peer [j][0], echostringlen [j], &echostring [j][0]);
                   if (echostringlen [j] > 3) /* 2 of these are the \n and \r */
                      {
                      x = echostringlen [j] / 2 + (echostringlen [j] % 2);
                      y = echostringlen [j] - x + 1;
                      strncpy (msg, &echostring [j][x - 1], y);
                      strncpy (&echostring [j][0], msg, y);
                      echostring [j][y] = 0x0;
                      echostringlen [j] = y;
                      }
                   else                        /* not enough left to remember */
                      echostringlen [j] = 0;   /* so just zero the length */
                   } /* if (recvBytes > 0) */
                } /* if (recvBytes == 0) -- else */
             } /* if (recvBytes == -1) -- else */
          } /* if (FD_ISSET (socks [j], &fdsetR)) */
       } /* for (j = 1; j < nSocks; j++) */
   } /* if (socksSelected > 0) */
else

/* nothing was ready for reading so we have a timeout */
   {
   if (socksSelected == 0)
      {                /* if all we have is the listening socket we can */
      if (nSocks > 1)  /* skip all this */
         {
         for (j = 1; j < nSocks; j++)
             {

/* this is pretty much the same code as above. The difference is in the
   the strings output to the terminal. Following the program name are 2
   colon caracters instead of 1. This is not a typo. I make it a rule
   never to output the same message from more than 1 spot. that way it is
   always obvious where the message came from */

             if (socketWaitingToConnect [j] > 0)
                {
                strcpy (msg, "Thank you for connecting to Noah's Echooooooo Serverrrrrrr\n");
                sendBytes = send (socks [j], msg, strlen (msg), 0);
                if (sendBytes < 0)          /* problem sending greeting */
                   {
                   if (errno == ENOTCONN)     /* not connected yet */
                      {
                      socketWaitingToConnect [j]++;
/* This is the point that you could add your own "I've waited long enough"
   code. Here is an example. If you don't add it then when the connection in
   SYN_RECV state times out select will signal that the socket is ready to
   read and recv will recv an EIO error.

                      if (socketWaitingToConnect [j] == 60)
                         {
                         printf ("echo:: Giving up waiting for a connection from %s\n", &peer [j][0]);
                         close (socks [j]);
                         socks [j] = 0;
                         peer [j][0] = 0x0;
                         echostring [j][0] = 0x0;
                         echostringlen [j] = 0;
                         socketWaitingToConnect [j] = 0;
                         } /* if (socketWaitingToConnect [j] == 60) 

This is the end of the above comment block
*/
                      } /* if (errno == ENOTCONN) */
                   else                     /* some other error, close down socket */
                      {
                      perror ("echo:: Unexpected error while sending greeting string");
                      close (socks [j]);
                      socks [j] = 0;
                      peer [j][0] = 0x0;
                      echostring [j][0] = 0x0;
                      echostringlen [j] = 0;
                      socketWaitingToConnect [j] = 0;
                      } /* if (errno == ENOTCONN) -- else */
                    } /* if (sendBytes < 0) */
                 else
                    socketWaitingToConnect [j] = 0; /* we have connection */
                 } /* if (socketWaitingToConnect [j] > 0) */

             if (echostringlen [j] > 0)   
                {
                sendBytes = send (socks [j], &echostring [j][0], echostringlen [j], 0);
                if (sendBytes != echostringlen [j])
                   printf ("echo:: problem sending echo string to %s only %d out of %d characters sent\n", &peer [j][0], sendBytes, echostringlen [j]);
                else
                   printf ("echo:: echoing to %s: %d bytes %s", &peer [j][0], echostringlen [j], &echostring [j][0]);

                if (echostringlen [j] > 3) /* 2 of these are the \n and \r */
                   {
                   x = echostringlen [j] / 2 + (echostringlen [j] % 2);
                   y = echostringlen [j] - x + 1;
                   strncpy (msg, &echostring [j][x - 1], y);
                   strncpy (&echostring [j][0], msg, y);
                   echostring [j][y] = 0x0;
                   echostringlen [j] = y;
                   }
                else
                   echostringlen [j] = 0;
                } /* if (echostringlen [j] > 0) */
             } /* for (j = 1; j < nSocks; j++) */
         } /* if (nSocks > 1) */
      } /* socksSelected == 0 */
   else /* socksSelected must be < 0 some kind of error from select */
      perror ("echo: Unexpected error from select");
   } /* if (socksSelected > 0) -- else */

goto again;
}

