#define _POSIX_SOURCE

#include <sys/select.h>
#include <prototypes/inet_proto.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <c_utilities.h>

#include <netdb.h>
#include <errno.h>
#include <error_codes.h>

#define bzero(s, len)             memset((char *)(s), 0, len)


void s$set_no_wait_mode(short int *,
                        long int *,
                        short int *);

void s$wait_event(short int *,
                  long int *,
                  long int *,
                  long int *,
                  short int *,
                  short int *);

void s$seq_read(short int *,
                short int *,
                short int *,
                char *,
                short int *);

int errno;

main (argc, argv)
int    argc;
char   *argv [];

{
 short port_no;                    /* port to send to - arg 1 */

 struct sockaddr_in serv_addr;     /* used to connect to IP address and port */
 struct sockaddr_in peer_addr;     /* used to hold respose from getpeername */
 int peer_len;                     /* length of peer_addr */

 int fcntl_flags;                  /* holds flags for fcntl function
                                      used to set non-blocking mode */

#define BUFFERLEN 100              /* how many bytes can we process at once */
 int socks0;                       /* our socket */
 char echostring [BUFFERLEN];      /* array holding characters to be
                                      echoed */
 int echostringlen = BUFFERLEN;    /* max number of characters in echostring
                                      array */

 struct hostent *hostinfo;         /* pointer for structure allocated by
                                      gethostbyname */

 int recvBytes, sendBytes;         /* number of bytes received and sent */

 short socketReady = 0;            /* flag to indicate that socket is ready
                                      to be read */
 short socketConnected = 0;        /* flag to indicate that socket has been
                                      connected */
 short int terminalReady = 1;      /* flag to indicate that the terminal is
                                      ready, i.e. something has been typed,
                                      it starts as ready so we can get a 
                                      caller_must_wait before calling
                                      s$wait_event */
 short int notConnectedCount = 0;  /* number of times getpeername has */
                                   /* returned ENOTCONN */

 short int term_port = 5;          /* port ID of the terminal */
 short int return_code = 0;        /* return code for s$ calls */
 short num_events = 2;             /* number of events given to s$wait_event */
 short current_event = 1;          /* event causing s$wait_event to return */
 short int record_len;             /* bytes read from terminal */
 short int max_len = BUFFERLEN;    /* max bytes in buffer */
 long int timeout = -1;            /* timeout for s$wait_event (forever) */

#define SOCKETEVENT 1              /* array index for socket event */
#define TERMEVENT 0                /* array index for terminal event */
 long int events [2];              /* event array for s$wait_event */
 long int event_counts [2];        /* event counts for s$wait_event */


 if (argc == 3)                    /* process the arguments. This is very */
    {                              /* simplestic argument processing, all */
    port_no = atoi (argv [1]);     /* arguments are required and are */
                                   /* positional. But then again this */
                                   /* example is not about argument */
    }                              /* processing */
 else                              /* if we don't have all the arguments */
    {                              /* print out a usage message */
    printf ("\nUsage: stcp_echo_client <port_number> <server name or IP address>\n");
    exit (-1);
    }

/* Leting you know what argument values will actually be used */

 printf ("echo_client %d %s\n\n", port_no, argv [2]);

/* set up the terminal port to be in no-wait mode. This also sets the
   value for the terminal event. */

 s$set_no_wait_mode(&term_port, &events [TERMEVENT], &return_code);
 if (return_code != 0)
    {
    printf ("echo_client: set_no_wait_mode failed with error code %d\n", return_code);
    exit (return_code);
    }
 event_counts [TERMEVENT] = -1;


/* create a stream socket */

 if ((socks0 = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
    perror ("echo_client: can't open stream socket");
    exit (errno);
    }

/* set non-blocking mode on the socket. At the moment doing a get and ORing
   in the O_NDELAY value is probably overkill since the only flag supported 
   at this time is O_NDELAY. But things may change in the future so (as was
   explained to be in painful detail with graphic images of bits crashing
   togther) its best to do things right. */

 fcntl_flags = fcntl(socks0, F_GETFL, 0);
 if (fcntl_flags < 0)
    {
    perror ("echo_client: could not get the current fcntl flags for listening socket");
    exit (errno);
    }

 fcntl_flags = fcntl_flags | O_NDELAY;

 if (fcntl(socks0, F_SETFL, fcntl_flags) < 0)
    {
    perror ("echo_client: could not set non blocking IO for listening socket");
    exit (errno);
    }

/* get the event and event_count  associated with the socket */

   get_socket_event (socks0, &events [SOCKETEVENT], &event_counts [SOCKETEVENT]);

/* start building the sockaddr_in structure that will be used for the
   connection */

 bzero ( (char *) &serv_addr, sizeof (serv_addr));
 serv_addr.sin_family        = AF_INET;
 serv_addr.sin_port          = htons (port_no);

/* resolve the server name. The STCP version of gethostbyname will return
   an IP address if given an IP address so if gethostbyname indicates a
   failure we know that the name is also not just an IP address. */

 hostinfo = gethostbyname (argv [2]);
 if (hostinfo == NULL)
    {
    printf ("\nCould not find address for host <%s>.\n", argv [2]);
    exit (-1);
    }
 else
    serv_addr.sin_addr.s_addr = *(unsigned long *)(hostinfo -> h_addr_list [0]);
 endhostent ();

/* Make the connection - note this is in non-blocking mode so
   it returns immediately */

 if (connect (socks0, (struct sockaddr *) &serv_addr, sizeof (serv_addr)) < 0)
    {
    if (errno != EINPROGRESS)
       {
       perror ("echo_client: failed to connect to server");
       exit (errno);
       }
    }

/* begining of main loop through the code */

again:

/* loop though both the socket and terminal while either is ready. Basically,
   keep going until we get e$caller_must_wait on both */

 while (socketReady || terminalReady)
       {
       if (socketReady) /* only if socket is ready */
          {
          recvBytes = recv (socks0, echostring, BUFFERLEN - 1, 0);
          if (recvBytes > 0)
             {
             socketReady = 1;             /* we have to go back and do this again */
             echostring [recvBytes] = 0;  /* set terminal null so printf will work */
             printf ("%s\n", echostring); /* write to terminal */
             }
          else
          if (recvBytes == 0)             /* server terminated the connection */
             {                            /* write a message and exit */
             printf ("Connection closed by server");
             exit (0);
             }
          else
          if (recvBytes == -1)      /* error during recv, go ahead and exit */
             {                      /* except ignore EAGAIN and ENOTCONN */
             if (!((errno == EAGAIN) || (errno == ENOTCONN)))
                {
                perror ("echo_client: Unexpected error while receiving");
                exit (errno);
                }
             else
                socketReady = 0; /* at this point we can stop doing recv */
             }                   /* until triggered by an event */
          } /* if (socketReady */
      
       if (terminalReady) /* only if something has been typed at terminal */
          {
          s$seq_read (&term_port, &max_len, &record_len, echostring, &return_code);
          if (return_code != 0)           /* error during s$seq_read, go ahead and */
             {                            /* exit except ignore caller_must_wait */
             if (return_code != e$caller_must_wait)
                {
                printf ("echo_client: unexpected error from s$seq_read %d\n", return_code);
                exit (return_code);
                }
             else
                terminalReady = 0; /* at this point we can stop doing s$seq_read */
             }                     /* until triggered by an event */
          else
             {
             echostringlen = record_len;  /* send all bytes we just read */
             if (socketConnected)         /* but only if we are connected */
                {
                sendBytes = send (socks0, echostring, echostringlen, 0);
                if (sendBytes != echostringlen) /* if we get an error or fail to send */
                   {                            /* all the bytes report it. Ideally */
                   if (sendBytes < 0)           /* I should go back and resend unsent */
                      {                         /* bytes but I am being lazy */
                      perror ("echo_client: unexpected error durning send");
                      exit (errno);             /* For this application it would be */
                      }                         /* very surprising not to send eveything */
                   else
                      printf ("echo_client: only %d bytes out of %d sent\n", sendBytes, echostringlen);
                   }
                } /* if (socketConnected) */
             else
                printf ("Socket not yet connected -- try again later \n");
             } /* if (return_code != 0) -- else */
          } /* if (terminalReady) ) */
      } /*  while (socketReady || terminalReady) */

/* Since we have gotten an e$caller_must_wait from the terminal and EAGAIN from
   the socket we can now do an s$wait_event */

 s$wait_event (&num_events, events, event_counts, &timeout, &current_event, &return_code);
 if (return_code != 0)
    {
    printf ("echo_client: s$wait_event returned %d\n", return_code);
    exit (return_code);
    }
 if (current_event == 1)
    terminalReady = 1;
 else
    {
    socketReady = 1;

/* If the socket is not connected the event is an indication that the connection
   completed or the failed. The call to getpeername will tell us which. If
   getpeername returns without an error we are connected and can set the
   socketConnected flag to 1. We reset the socketReady flag to 0 because there is
   nothing to recv yet. If getpeername returns an error we are not connected. For
   some reason STCP sockets always get an event immediately and then getpeername 
   indicates the socket is not connected. You have to wait for the second event
   to decided if the socket is truely connected or not */

    if (!socketConnected)
       {
       peer_len = sizeof (peer_addr);
       if (getpeername (socks0, (struct sockaddr *) &peer_addr, &peer_len) == 0)
          {
          socketConnected = 1;
          printf ("Connection to server %s completed\n", argv [2]);
          socketReady = 0; /* we just got connected, should be nothing */
          }                /* to read */
       else
          {
          if (errno != ENOTCONN) /* unknown error - abort */
             {
             perror ("echo_client: Error from getpeername");
             exit (errno);
             }
          else
             {
             notConnectedCount++;         /* wait for the second ENOTCONN error */
             if (notConnectedCount == 2)  /* before failing */
                {
                printf ("Connection to server %s failed\n", argv [2]);
                exit (errno);
                }
             socketReady = 0;             /* don't try to recv yet */
             }
          } /* if (getpeername (socks0, &peer_addr, &peer_len) == 0) -- else */
       } /* if (!socketConnected) */
    } /* if (return_code != 0) -- else */

 goto again;
}
