#define _POSIX_SOURCE /* needed for posix */

#include <sys/select.h>
#include <prototypes/inet_proto.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <c_utilities.h>

/*
#include <sys/types.h>
#include <sys/select.h>
#include <sys/socket.h> 
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <prototypes/inet_proto.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <streamio.h>
#include <string.h>
#include <errno.h>
#include <error_codes.h>
#include <c_utilities.h>
*/

#define bzero(s, len)             memset((char *)(s), 0, len)

int errno;

main (argc, argv)
int    argc;
char   *argv [];

{
 int   ka_timer;                   /* flag for keep alive - arg 1 */
 short delay;                      /* delay between echos in seconds - arg 2 */
 short lingertime = 0;             /* linger time in seconds - arg 3 */

 struct sockaddr_in cli_addr;      /* holds address of remote from accept */
 int    clilen;                    /* holds length of cli_addr structure) */
 int    nfds;                      /* max sock FD value, used in select */
 fd_set fdsetR;                    /* set of FDs to be tested by select */

 struct timeval timeout;           /* holds select timeout value */
 struct linger  linger1;           /* linger structure */
 int nodelay = 1;                  /* flag to control no delay setting */
 int reuse = 1;                    /* flag to control address reuse */
 int fcntl_flags;                  /* holds flags for fcntl function
                                      used to set non-blocking mode */
#define BUFFERLEN 100              /* how many bytes can we process at once */
 int socks0 = 0;                   /* socket ID based on STDIN */
 char peer[16];                    /* array holding string containing IP
                                      address of remote peer for socker */
 char echostring [BUFFERLEN];      /* array holding characters to be echoed */
 int echostringlen;                /* array holding number of character in
                                      echostring array */

 short socksSelected;              /* number of sockets that select indicates
                                      are ready */

 int recvBytes, sendBytes;         /* number of bytes received and sent */
 char msg [257];                   /* temporary space for a string */
 char *peer_x;                     /* temporary space to hold the string
                                      containing peer's IP address */
 int savedErrno;                   /* temporary to save last errno */
 short i, j, x, y;                 /* loop counters and temporaries */

 FILE *outFile;                    /* outfile for messages */

 if (argc == 4)                    /* process the arguments. This is very */
    {                              /* simplestic argument processing, all */
    ka_timer = atoi (argv [1]);    /* positional. But then again this */
    delay = atoi (argv [2]);       /* example is not about argument */
    lingertime = atoi (argv [3]);  /* processing */
    }
 else                              /* if we don't have all the arguments */
    {                              /* print out a usage message */
    outFile = fopen ("%phx_cac_j14#m14_d02>CAC>Noah_Davids>stratus_world_2004>stcp_inetd_echo.error", "w+");
    if (outFile == NULL)   /* deep do-do we can't create an output file for */
       exit (errno);       /* usage message */

    fprintf (outFile, "\nUsage: stcp_inetd_echo <keep_alive timer> <echo delay in seconds> <linger seconds>\n");
    fprintf (outFile, "\t\tkeep_alive timer  -- 0 no keep alive\n");
    fprintf (outFile, "\t\tminimum delay 1, maximum delay is 15\n");
    fprintf (outFile, "\t\ta negative value for linger will cause it not to be set, 0 is valid\n");
    fclose (outFile);
    exit (-1);
    }

/* Now who are we connected to */

 clilen = sizeof (cli_addr);
 if (getpeername (socks0, (struct sockaddr *) &cli_addr, &clilen) < 0)
    exit (errno);

/* Build the outfile from the PM path and the peer IP address and port */

 peer_x = inet_ntoa (cli_addr.sin_addr);  /* get peers address */
 strcpy (peer, peer_x);                   /* and save it */
 strncpy (msg, argv [0], strlen (argv [0]) - 15); /* strip off PM name */
 sprintf (msg, "%secho_%s,%d", msg, peer,  ntohs (cli_addr.sin_port));
 outFile = fopen (msg, "w+");
 if (outFile == NULL)
    {
    savedErrno = errno;
    outFile = fopen ("%phx_cac_j14#m14_d02>CAC>Noah_Davids>stratus_world_2004>stcp_inetd_echo.error", "w+");
    if (outFile == NULL)
       exit (savedErrno);
    fprintf (outFile, "Could not create output file %s\n", msg);
    fprintf (outFile, "errno = %d\n", savedErrno);
    exit (savedErrno);
    }

 fprintf (outFile, "Connection from %s\n", peer);

/* sanity check the values of the arguments. The max and min values are based
   on my view or reality, yours may be different
*/
 if (delay > 15)
    {
    fprintf (outFile, "%d is just too long a delay adjusting to 5\n");
    delay = 5;
    }
 if (delay < 1) 
    {
    fprintf (outFile, "%d is just too short a delay adjusting to 1\n", delay);
    delay = 1;
    }
 if ((ka_timer < 120) && (ka_timer != 0))
    {
    printf ("%d is just too short a keep alive value adjusting to 120\n", ka_timer);
    ka_timer = 120;
    }
 if (ka_timer > 14400)
    {
    printf ("%d is just too large a keep alive value adjusting to 14400\n", ka_timer);
    ka_timer = 14400;
    }

/* Leting you know what argument values will actually be used */

 fprintf (outFile, "inetd_echo %d %d %d\n\n", ka_timer, delay, lingertime);

/* load the timeout struction based on the input delay value. This will be used
   by select. */

 timeout.tv_sec = delay;
 timeout.tv_usec = 0;

/* set a bunch of sock options */

/* set the linger timer if its greater than -1. */

 if (lingertime > -1)
    {
    linger1.l_onoff = 1;
    linger1.l_linger = lingertime;
    if (setsockopt (socks0, SOL_SOCKET, SO_LINGER, (char *) &linger1, sizeof (linger1)) < 0)
       {
       fprintf (outFile, "inetd_echo: Error setting linger %d\n", errno);
       exit (errno);
       }
    }

/* turn keep alive on so any connections that are left hanging can be cleaned
   up eventually. */

 if (ka_timer != 0)
    {
    linger1.l_onoff = 1;
    linger1.l_linger = ka_timer;
    if (setsockopt (socks0, SOL_SOCKET, SO_KEEPALIVE, (char *) &linger1, sizeof (linger1)) < 0)
      {
      fprintf (outFile, "inetd_echo: Error setting keepalive %d\n", errno);
      exit (errno);
      }
    }

/* turn on no delay. This turns off the nagel algorithm so that we can send
   multiple small (less than MSS) packets without waiting for an ACK. */

 if (setsockopt (socks0, IPPROTO_TCP, TCP_NODELAY, (char *) &nodelay, sizeof (nodelay)) < 0)
    {
    fprintf (outFile, "inetd_echo: Error setting nodelay %d\n", errno);
    exit (errno);
    }

/* set non-blocking mode on the socket. At the moment doing a get and ORing
   in the O_NDELAY value is probably overkill since the only flag supported 
   at this time is O_NDELAY. But things may change in the future so (as was
   explained to be in painful detail with graphic images of bits crashing
   togther) its best to do things right. */

 fcntl_flags = fcntl(socks0, F_GETFL, 0);
 if (fcntl_flags < 0)
    {
    perror ("inetd_echo: could not get the current fcntl flags for listening socket");
    exit (errno);
    }

 fcntl_flags = fcntl_flags | O_NDELAY;

 if (fcntl(socks0, F_SETFL, fcntl_flags) < 0)
    {
    perror ("inetd_echo: could not set non blocking IO for listening socket");
    exit (errno);
    }

again:

/* reset the file descriptor array for select. This has to be done every time
   you go through select since select will modify this array */

FD_ZERO (&fdsetR);
FD_SET (socks0, &fdsetR);
nfds = socks0 + 1;

/* Do the select. We are only interested in reading and a timeout so the
   write and exception arguments are null */

socksSelected = select (nfds, &fdsetR, (fd_set *) 0, (fd_set *) 0, &timeout);

if (socksSelected < 0)
   {
   perror ("inetd_echo: select returned with an error, give up at this point");
   exit (errno);
   }

/* if select returns a value greater than 0 it indicates that the socket
   is ready for reading. */

if (socksSelected > 0)
   {
   if (!FD_ISSET (socks0, &fdsetR))        /* just a sanity check since */
      {                                    /* there is only 1 socket */
                                           /* this should always be true */
      fprintf (outFile, "inetd_echo: select returned a socket we didn't expect\n");
      exit (-1);
      }
   else
      { 
      if (echostringlen > 2)                 /* "remove" ending \n\r that */
          echostringlen = echostringlen - 2; /* were added */

/* receive bytes based on the number of bytes left in buffer. There will
   be bytes left in the buffer if we have not completed echoing the last
   string sent to us. We also need to leave room for the \n\r\0 that will be
   added to the end of the buffer. If there are more bytes in the receive
   queue then can fit in the buffer the next time select is called it will
   immediately indicate that the socket is ready for reading */

      recvBytes = recv (socks0, &echostring[echostringlen], BUFFERLEN - echostringlen - 3, 0);
      if (recvBytes == -1)  /* error during recv, clean up the socks */
         {                  /* and related arrays */
         fprintf (outFile, "inetd_echo: Unexpected error while receiving on socket connected to %s %d\n", peer, errno);
         exit (errno);
         }
      else                 /* no error on recv */
         {
         if (recvBytes == 0)  /* indicates connection was closed by peer */
            {
            fprintf (outFile, "inetd_echo: closing connection for %s\n", peer);
            if (close (socks0) < 0)  /* close our socket */
               {
               fprintf (outFile, "inetd_echo: error closing socket connected to %s %d\n", peer, errno);
               }
            fclose (outFile);
            exit (0);
            }
         else       /* we actually had bytes to read and we read them */
            {

/* adjust the number of bytes we have in the buffer to include what was just 
   read. Then add a \n\r\0 to it. The \n\r is needed so that when we echo
   the bytes we move the cursor down to the next line. Some clients, like
   telnet will not do that for the user. Without the \n\r the output becomes
   very strange. The \0 is needed so that %s in printf works correctly */

            echostringlen = echostringlen + recvBytes;
            echostring [echostringlen] = '\n';
            echostring [echostringlen + 1] = '\r';
            echostring [echostringlen + 2] = 0x0;
            echostringlen = echostringlen + 2;

/* now print the string but start from what was the end of the buffer so we 
   print only the bytes that were just received. */

            fprintf (outFile, "inetd_echo: received from %s: %d bytes %s\n", peer, recvBytes, &echostring [echostringlen - recvBytes - 2]);

/* now send the entire buffer, any old bytes and the new bytes */

            sendBytes = send (socks0, &echostring [0], echostringlen, 0);

/* if we didn't send all the bytes we had some kind of problem. Ideally at this
   point I could loop and try to send again or take some kind of exception
   problem. It is not strictly speaking an error. I choose just to report it.
   ALWAYS CHECK and take appropriate action, never assume that all characters
   were sent */

            if (sendBytes != echostringlen)
               fprintf (outFile, "inetd_echo: problem sending echo string to %s only %d out of %d characters sent\n", peer, sendBytes, echostringlen);
            else

/* If all characters were sent OK echo that and then cut the buffer in half
   and remeber the last half for further echoing */

               fprintf (outFile, "inetd_echo: echoing to %s: %d bytes %s", peer, echostringlen, &echostring [0]);
            if (echostringlen > 3) /* 2 of these are the \n and \r */
               {
               x = echostringlen / 2 + (echostringlen % 2);
               y = echostringlen - x + 1;
               strncpy (msg, &echostring [x - 1], y);
               strncpy (&echostring [0], msg, y);
               echostring [y] = 0x0;
               echostringlen = y;
               }
            else                        /* not enough left to remember */
               echostringlen = 0;       /* so just zero the length */
            } /* if (recvBytes == 0) -- else */
         } /* if (recvBytes == -1 -- else */
      } /* if (FD_ISSET (socks0, &fdsetR)) -- else */
   } /* if (socksSelected > 0) */
else

/* nothing was ready for reading so we have a timeout */
  {

/* this is pretty much the same code as above. The difference is in the
   the strings output to the terminal. Following the program name are 2
   colon caracters instead of 1. This is not a typo. I make it a rule
   never to output the same message from more than 1 spot. that way it is
   always obvious where the message came from */

  if (socksSelected == 0)
     {
     if (echostringlen > 0)   
        {
        sendBytes = send (socks0, &echostring [0], echostringlen, 0);
        if (sendBytes != echostringlen)
           fprintf (outFile, "inetd_echo:: problem sending echo string to %s only %d out of %d characters sent\n", peer, sendBytes, echostringlen);
        else
           fprintf (outFile, "inetd_echo:: echoing to %s: %d bytes %s", peer, echostringlen, &echostring [0]);
        if (echostringlen > 3) /* 2 of these are the \n and \r */
           {
           x = echostringlen / 2 + (echostringlen % 2);
           y = echostringlen - x + 1;
           strncpy (msg, &echostring [x - 1], y);
           strncpy (&echostring [0], msg, y);
           echostring [y] = 0x0;
           echostringlen = y;
           }
        else
           echostringlen = 0;
        } /*   if (echostringlen > 0) */
     } /* if (socksSelect == 0) */
  else /* socksSelected must be < 0 some kind of error from select */
     fprintf (outFile, "inetd_echo: Unexpected error from select %d\n", errno);
  } /* if (socksSelected > 0) -- else */

goto again;
}

