#define _POSIX_SOURCE

#include <sys/select.h>
#include <prototypes/inet_proto.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <c_utilities.h>

#include <netdb.h>
#include <errno.h>
#include <error_codes.h>

#define bzero(s, len)             memset((char *)(s), 0, len)

void s$set_no_wait_mode(short int *,
                        long int *,
                        short int *);

void s$wait_event(short int *,
                  long int *,
                  long int *,
                  long int *,
                  short int *,
                  short int *);

void s$seq_read(short int *,
                short int *,
                short int *,
                char *,
                short int *);

int errno;

main (argc, argv)
int    argc;
char   *argv [];

{
 short port_no;                    /* port to send to - arg 1 */
 char  localIP [16];               /* interface to send multicasts out - arg 2 */
 char  multicastIP [16];           /* multicast address to send to - arg 3 */
 short port_no_2;                  /* port to receive on - arg 2 */

 struct sockaddr_in serv_addr;     /* used to hold server's IP address and 
                                      port */
 struct sockaddr_in my_addr;       /* used to hold my address and port */
 struct sockaddr_in recv_addr;     /* holds senders addr returned from
                                      recvfrom */
 struct ip_mreq mreq;              /* hold local and multicast IPs for
                                      joining multicast group */
 int recvlen;                      /* length of recv_addr structure */

 int fcntl_flags;                  /* holds flags for fcntl function
                                      used to set non-blocking mode */

#define BUFFERLEN 100              /* how many bytes can we process at once */
 int socks0;                       /* socket used to receive replies*/
 int socks1;                       /* socket used to send to server */
 char echostring [BUFFERLEN];      /* array holding characters to be
                                      echoed */
 int echostringlen = BUFFERLEN;    /* max number of characters in echostring
                                      array */

 struct hostent *hostinfo;         /* pointer for structure allocated by
                                      gethostbyname */

 int recvBytes, sendBytes;         /* number of bytes sent and received */

 short socketReady = 0;            /* flag to indicate that socket is ready
                                      to be read */
 short int terminalReady = 1;      /* flag to indicate that the terminal is
                                      ready, i.e. something has been typed,
                                      it starts as ready so we can get a 
                                      caller_must_wait before calling
                                      s$wait_event */

 short int term_port = 5;          /* port ID of the terminal */
 short int return_code = 0;        /* return code for s$ calls */
 short num_events = 2;             /* number of events given to s$wait_event */
 short current_event = 1;          /* event causing s$wait_event to return */
 short int record_len;             /* bytes read from terminal */
 short int max_len = BUFFERLEN;    /* max bytes in buffer */
 long int timeout = -1;            /* timeout for s$wait_event (forever) */

#define SOCKETEVENT 1              /* array index for socket event */
#define TERMEVENT 0                /* array index for terminal event */
 long int events [2];              /* event array for s$wait_event */
 long int event_counts [2];        /* event counts for s$wait_event */


 if (argc == 6)                    /* process the arguments. This is very */
    {                              /* simplestic argument processing, all */
    port_no = atoi (argv [1]);     /* arguments are required and are */
    strcpy (localIP, argv [2]);    /* positional. But then again this */
    strcpy (multicastIP, argv [3]);/* example is not about argument */
    port_no_2 = atoi (argv [4]);   /* processing */
    }                              
 else                              /* if we don't have all the arguments */
    {                              /* print out a usage message */
    printf ("\nUsage: stcp_mc_echo_client <server port number> <local IP> <multicast IP> <receiving port number> <server name or IP address>\n");
    exit (-1);
    }

/* Leting you know what argument values will actually be used */

 printf ("mc_echo_client %d %s %s %d %s\n\n", port_no, localIP, multicastIP, port_no_2, argv [5]);

/* set up the terminal port to be in no-wait mode. This also sets the
   value for the terminal event. */

 s$set_no_wait_mode(&term_port, &events [TERMEVENT], &return_code);
 if (return_code != 0)
    {
    printf ("mc_echo_client: set_no_wait_mode failed with error code %d\n", return_code);
    exit (return_code);
    }
 event_counts [TERMEVENT] = -1;


/* create a stream sockets */

 if ((socks0 = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
    {
    perror ("mc_echo_client: can't open dgram socket socks0");
    exit (errno);
    }

 if ((socks1 = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
    {
    perror ("mc_echo_client: can't open dgram socket socks1");
    exit (errno);
    }

/* set non-blocking mode on the socket. At the moment doing a get and ORing
   in the O_NDELAY value is probably overkill since the only flag supported 
   at this time is O_NDELAY. But things may change in the future so (as was
   explained to be in painful detail with graphic images of bits crashing
   togther) its best to do things right. */

 fcntl_flags = fcntl(socks0, F_GETFL, 0);
 if (fcntl_flags < 0)
    {
    perror ("mc_echo_client: could not get the current fcntl flags for listening socket");
    exit (errno);
    }

 fcntl_flags = fcntl_flags | O_NDELAY;

 if (fcntl(socks0, F_SETFL, fcntl_flags) < 0)
    {
    perror ("mc_echo_client: could not set non blocking IO for listening socket");
    exit (errno);
    }

/* get the event and event_count  associated with the socket */

   get_socket_event (socks0, &events [SOCKETEVENT], &event_counts [SOCKETEVENT]);

/* build my sock_addr so that I can bind to it */

 bzero ( (char *) &my_addr, sizeof (my_addr));
 my_addr.sin_family        = AF_INET;
 my_addr.sin_port          = htons (port_no_2);
 my_addr.sin_addr.s_addr   = inet_addr (multicastIP);
 if (my_addr.sin_addr.s_addr == -1)
    {
    printf ("mc_echo_client: multicast address argument %s is not an IP address\n", multicastIP);
    exit (-1);
    }

 if (bind (socks0, (struct sockaddr *) &my_addr, sizeof (my_addr)) < 0)
    {
    perror ("mc_echo_client: can't multicast address");
    exit (errno);
    }

/* join the multicast group */

mreq.imr_interface.s_addr = inet_addr (localIP);
 if (mreq.imr_interface.s_addr == -1)
    {
    printf ("mc_echo_client: localIP address argument %s is not an IP address\n", multicastIP);
    exit (-1);
    }
mreq.imr_multiaddr.s_addr = inet_addr (multicastIP);

if (setsockopt (socks0, IPPROTO_IP, IP_ADD_MEMBERSHIP, (char *) &mreq, sizeof(mreq)) == -1)
    {
    perror ("mc_echo_client: Error joining multicast group");
    exit (errno);
    }

/* start building the sockaddr_in structure that will be used for sending
   to the server */

 bzero ( (char *) &serv_addr, sizeof (serv_addr));
 serv_addr.sin_family        = AF_INET;
 serv_addr.sin_port          = htons (port_no);

/* resolve the server name. The STCP version of gethostbyname will return
   an IP address if given an IP address so if gethostbyname indicates a
   failure we know that the name is also not just an IP address. */

 hostinfo = gethostbyname (argv [5]);
 if (hostinfo == NULL)
    {
    printf ("\nCould not find address for host <%s>.\n", argv [5]);
    exit (-1);
    }
 else
    serv_addr.sin_addr.s_addr = *(unsigned long *)(hostinfo -> h_addr_list [0]);
 endhostent ();

/* begining of main loop through the code */

again:

/* loop though both the socket and terminal while either is ready. Basically,
   keep going until we get e$caller_must_wait on the terminal and EAGAIN on
   the socket */

 while (socketReady || terminalReady)
       {
       if (socketReady)
          {
          recvlen = sizeof (recv_addr);
          recvBytes = recvfrom (socks0, echostring, BUFFERLEN - 1, 0, (struct sockaddr *) &recv_addr, &recvlen);
          if (recvBytes > 0)
             {
             socketReady = 1;             /* we have to go back and do this again */
             echostring [recvBytes] = 0;  /* set terminal null so printf will work */
             printf ("%s\n", echostring); /* write to terminal */
             }
          else
          if (recvBytes == -1)            /* error during recv, go ahead and exit */
             {                            /* except ignore EAGAIN */
             if (errno != EAGAIN)
                {
                perror ("mc_echo_client: Unexpected error while receiving");
                exit (errno);
                }
             else
                socketReady = 0;
             } /* if (recvBytes == -1) */
          } /* if (socketReady */
      
          if (terminalReady)
             {
          s$seq_read (&term_port, &max_len, &record_len, echostring, &return_code);
          if (return_code != 0)           /* error during s$seq_read, go ahead and */
             {                            /* exit except ignore caller_must_wait */
             if (return_code != e$caller_must_wait)
                {
                printf ("mc_echo_client: unexpected error from s$seq_read %d\n", return_code);
                exit (return_code);
                }
             else
                terminalReady = 0;
             }
          else
             {
             echostringlen = record_len;  /* send all bytes we just read */
             sendBytes = sendto (socks1, echostring, echostringlen, 0, (struct sockaddr *) &serv_addr, sizeof (serv_addr));

/* if we didn't send all the bytes just report it. I should put in a loop 
   resend the data but I am being lazy. Also in this application it is very 
   unlikely that this condition will occur. */

             if (sendBytes != echostringlen)
                {
                if (sendBytes > 0)
                   printf ("mc_echo_client: only %d bytes out of %d sent\n", sendBytes, echostringlen);
                else  /* if we are here we have an error */
                   {
                   if (errno == ECONNREFUSED) /* note in 14.7 STCP will no longer return this 
                                                 error or ENETUNREACH for unconnected UDP sockets */
                      printf ("Server on %s is not yet listening on port %d\n", argv [5], port_no);
                   else
                      {
                      perror ("mc_echo_client: unexpected error durning sendto");
                      exit (errno);
                      }
                   }
                }
             } /* if (return_code != 0) -- else */
          } /* if (terminalReady) ) */
      } /*  while (socketReady || terminalReady) */

/* Since we have gotten an e$caller_must_wait from both events we can now do
   an s$wait_event */

 s$wait_event (&num_events, events, event_counts, &timeout, &current_event, &return_code);
 if (return_code != 0)
    {
    printf ("mc_echo_client: s$wait_event returned %d\n", return_code);
    exit (return_code);
    }
 if (current_event == 1)
    terminalReady = 1;
 else
    socketReady = 1;
    
goto again;
}

