#define _POSIX_SOURCE

#include <sys/select.h>
#include <prototypes/inet_proto.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <c_utilities.h>

#include <errno.h>

#define bzero(s, len)             memset((char *)(s), 0, len)

int errno;

main (argc, argv)
int    argc;
char   *argv [];

{
 short port_no;                    /* port to listen on - arg 1 */
 char  localIP [16];               /* interface to send multicasts out - arg 2 */
 char  multicastIP [16];           /* multicast address to send to - arg 3 */
 short port_no_2;                  /* port number to send to arg 4 */
 short delay;                      /* delay between echos in seconds - arg 5 */
 int   recvbuf = 0;                /* receive buffer size in bytes - arg 6 */
 int   sendbuf = 0;                /* send byffer size in bytes - arg 7 */

 struct sockaddr_in serv_addr;     /* used to bind to IP address and port */
 struct sockaddr_in cli_addr;      /* holds address of remote from accept */
 int    clilen;                    /* holds length of cli_addr structure) */
 struct sockaddr_in multicast_addr;/* holds the multicast address */
 int    multicastlen;              /* hold length of the multicast_addr */
 struct in_addr ifaddr;            /* holds an interface address, used to set
                                      the default interface for multicast
                                      output */
 int    ttl = 2;                   /* TTL to be used with multicast packets */
 int    nfds;                      /* max sock FD value, used in select */
 fd_set fdsetR;                    /* set of FDs to be tested by select */

 struct timeval timeout;           /* holds select timeout value */
 int fcntl_flags;                  /* holds flags for fcntl function
                                      used to set non-blocking mode */
#define BUFFERLEN 1000             /* how many bytes can we process at once */
 int socks0;                       /* array holding the socket FDs */
 char peer[16];                    /* array holding string containing IP
                                      address of remote peer for socker */
 char echostring [BUFFERLEN];      /* array holding characters to be echoed */
 int echostringlen;                /* array holding number of character in
                                      echostring array */

 short socksSelected;              /* number of sockets that select indicates
                                      are ready */

 int recvBytes, sendBytes;         /* number of bytes received and sent */
 char msg [257];                   /* temporary space for a string */
 char *peer_x;                     /* temporary space to hold the string
                                      containing peer's IP address */
 int savedErrno;                   /* temporary to save last errno */
 short i, j, x, y;                 /* loop counters and temporaries */

 FILE *outFile;                    /* outfile for messages */

 if (argc == 8)                    /* process the arguments. This is very */
    {                              /* simplestic argument processing, all */
    port_no = atoi (argv [1]);     /* positional. But then again this */
    strcpy (localIP, argv [2]);    /* example is not about argument */
    strcpy (multicastIP, argv [3]);/* processing */
    port_no_2 = atoi (argv [4]);
    delay = atoi (argv [5]);
    recvbuf = atoi (argv [6]);
    sendbuf = atoi (argv [7]);
    }
 else                              /* if we don't have all the arguments */
    {                              /* print out a usage message */
    printf ("\nUsage: stcp_multicast_echo <listening port number> <local IP> <multicast IP> <sending port number> <echo delay in seconds> <receive buffer size> <send buffer size>\n");
    printf ("\t\tminimum delay 1, maximum delay is 15\n");
    printf ("\t\ta value of 0 for the receive/send buffers will cause these options not to be set\n");
    exit (-1);
    }

/* sanity check the values of the arguments. The max and min values are based
   on my view or reality, yours may be different
*/
 if (delay > 15)
    {
    printf ("%d is just too long a delay adjusting to 5\n");
    delay = 5;
    }
 if (delay < 1) 
    {
    printf ("%d is just too short a delay adjusting to 1\n", delay);
    delay = 1;
    }
 if (recvbuf > 64000)
    {
    printf ("%d is just too large a receive buffer, changing to 32000\n", recvbuf);
    recvbuf = 32000;
    }
 if ((recvbuf < 5000) && (recvbuf != 0))
    {
    printf ("%d is just too small a receive buffer, changing to 5000\n", recvbuf);
    recvbuf = 5000;
    }
 if (sendbuf > 64000)
    {
    printf ("%d is just too large a send buffer, changing to 32000\n", sendbuf);
    sendbuf = 32000;
    }
 if ((sendbuf < 5000) && (sendbuf != 0))
    {
    printf ("%d is just too small a send buffer, changing to 5000\n", sendbuf);
    sendbuf = 5000;
    }

/* Leting you know what argument values will actually be used */

 printf ("multicast_echo %d %s %s %d %d %d %d\n", port_no, localIP, multicastIP, port_no_2, delay, recvbuf, sendbuf);

/* load the timeout structure based on the input delay value. This will be used
   by select. */

 timeout.tv_sec = delay;
 timeout.tv_usec = 0;

/* create a stream socket */

 if ((socks0 = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
    {
    perror ("multicast_echo: can't open dgram socket");
    exit (errno);
    }

/* set a bunch of sock options */

/* change the size of the send and receive buffers. This is probably overkill
   for this program but it provides an example of how to do it

   Note that these options are not supported until 14.7/15.0 and then only
   for UDP so errors are reported but are not fatal */

 if (recvbuf != 0)
    {
    if (setsockopt (socks0, SOL_SOCKET, SO_RCVBUF, (char *) &recvbuf, sizeof (recvbuf)) < 0)
       perror ("multicast_echo: Error setting receive buffer size");
    }

 if (sendbuf != 0)
    {
    if (setsockopt (socks0, SOL_SOCKET, SO_SNDBUF, (char *) &sendbuf, sizeof (sendbuf)) < 0)
       perror ("multicast_echo: Error setting send buffer size");
    }

/* set non-blocking mode on the socket. At the moment doing a get and ORing
   in the O_NDELAY value is probably overkill since the only flag supported 
   at this time is O_NDELAY. But things may change in the future so (as was
   explained to be in painful detail with graphic images of bits crashing
   togther) its best to do things right. */

 fcntl_flags = fcntl(socks0, F_GETFL, 0);
 if (fcntl_flags < 0)
    {
    perror ("multicast_echo: could not get the current fcntl flags for listening socket");
    exit (errno);
    }

 fcntl_flags = fcntl_flags | O_NDELAY;

 if (fcntl(socks0, F_SETFL, fcntl_flags) < 0)
    {
    perror ("multicast_echo: could not set non blocking IO for listening socket");
    exit (errno);
    }

/* build a sockaddr structure holding the address we will bind to. The IP
   address is INADDR_ANY meaning we will listen on all active IP addresses */

 bzero ( (char *) &serv_addr, sizeof (serv_addr));
 serv_addr.sin_family        = AF_INET;
 serv_addr.sin_addr.s_addr   = htonl (INADDR_ANY);
 serv_addr.sin_port          = htons (port_no);

/* now bind to the address and port */

 if (bind (socks0, (struct sockaddr *) &serv_addr, sizeof (serv_addr)) < 0)
    {
    perror ("multicast_echo: can't bind local address");
    exit (errno);
    }

/* associate an interface to be used to send out multicast packets
   this is needed only if there is no routing table entry */

 ifaddr.s_addr = inet_addr(localIP);
 if (ifaddr.s_addr == -1)
    {
    printf ("multicast_echo: local address argument %s is not an IP address\n", localIP);
    exit (-1);
    }
 else
    {
    if (setsockopt(socks0, IPPROTO_IP, IP_MULTICAST_IF, (char *)&ifaddr, sizeof(struct in_addr)) < 0)
       {
       perror ("multicast_echo: Could not set local interface");
       exit (errno);
       }
    }

/* set the Time To Live to 2 */

 if (setsockopt(socks0, IPPROTO_IP, IP_MULTICAST_TTL, (char *)&ttl, sizeof(ttl)) < 0)
    {
    perror ("multicast_echo: setting multicast TTL to 2");
    exit (errno);
    }

/* create a sockaddr structure holding the multicast address. */ 

 bzero ( (char *) &multicast_addr, sizeof (multicast_addr));
 multicast_addr.sin_family        = AF_INET;
 multicast_addr.sin_addr.s_addr   = inet_addr (multicastIP);
 if (multicast_addr.sin_addr.s_addr == -1)
    {
    printf ("multicast_echo: multicast address argument %s is not an IP address\n", multicastIP);
    exit (-1);
    }
 multicast_addr.sin_port          = htons (port_no_2);

 multicastlen = sizeof (multicast_addr);

again:

/* reset the file descriptor array for select. This has to be done every time
   you go through select since select will modify this array */

FD_ZERO (&fdsetR);
FD_SET (socks0, &fdsetR);
nfds = socks0 + 1;

/* Do the select. We are only interested in reading and a timeout so the
   write and exception arguments are null */

/* big note, if there is any chance of having more 1024 total file decriptors
   besure to bind with posix libraries or use poll instead of select */

socksSelected = select (nfds, &fdsetR, (fd_set *) 0, (fd_set *) 0, &timeout);

if (socksSelected < 0)
   {
   perror ("multicast_echo: select returned with an error, give up at this point");
   exit (errno);
   }

/* if select returns a value greater than 0 it indicates that the socket
   is ready for reading. */

if (socksSelected > 0)
   {
   if (!FD_ISSET (socks0, &fdsetR))        /* just a sanity check since */
      {                                    /* there is only 1 socket */
                                           /* this should always be true */
      printf ("multicast_echo: select returned a socket we didn't expect\n");
      exit (-1);
      }
   else
      { 
      if (echostringlen > 2)                 /* "remove" ending \n\r that */
          echostringlen = echostringlen - 2; /* were added */

/* receive bytes based on the number of bytes left in buffer. There will
   be bytes left in the buffer if we have not completed echoing the last
   string sent to us. We also need to leave room for the \n\r\0 that will be
   added to the end of the buffer. If there are more bytes in the receive
   queue then can fit in the buffer the next time select is called it will
   immediately indicate that the socket is ready for reading */

      clilen = sizeof (cli_addr);     /* who are they from */
      recvBytes = recvfrom (socks0, &echostring[echostringlen], BUFFERLEN - echostringlen - 3, 0, (struct sockaddr *) &cli_addr, &clilen);
      if (recvBytes == -1)  /* error during recv, clean up the socks */
         {                  /* and related arrays */
         if ((errno != 0) && (errno != EAGAIN)) /* current erro is 0 I */
            {                                 /* expect it should be EAGAIN */
            perror ("multicast_echo: Unexpected error while receiving");
            printf ("recvBytes = %d, errno = %d, echostringlen = %d\n",
                    recvBytes, errno, echostringlen);
            exit (errno);
            }
         }
      else                 /* no error on recv */
         {
         peer_x = inet_ntoa (cli_addr.sin_addr);
         strcpy (peer, peer_x);

/* adjust the number of bytes we have in the buffer to include what was just 
   read. Then add a \n\r\0 to it. The \n\r is needed so that when we echo
   the bytes we move the cursor down to the next line. Some clients 
   will not do that for the user. Without the \n\r the output becomes
   very strange. The \0 is needed so that %s in printf works correctly */

         echostringlen = echostringlen + recvBytes;
         echostring [echostringlen] = '\n';
         echostring [echostringlen + 1] = '\r';
         echostring [echostringlen + 2] = 0x0;
         echostringlen = echostringlen + 2;

/* now print the string but start from what was the end of the buffer so we 
   print only the bytes that were just received. */

            printf ("multicast_echo: received from %s: %d bytes %s\n", peer, recvBytes, &echostring [echostringlen - recvBytes - 2]);

/* now send the entire buffer, any old bytes and the new bytes */

            sendBytes = sendto (socks0, &echostring [0], echostringlen, 0, (struct sockaddr *) &multicast_addr, multicastlen);

/* if we didn't send all the bytes we had some kind of problem. Ideally at this
   point I could loop and try to send again or take some kind of exception
   problem. It is not strictly speaking an error. I choose just to report it.
   ALWAYS CHECK and take appropriate action, never assume that all characters
   were sent */

            if (sendBytes != echostringlen)
               {
               if (sendBytes == -1)
                  perror ("multicast_echo: could send echo");
               else
                  printf ("multicast_echo: problem sending echo string only %d out of %d characters sent\n", sendBytes, echostringlen);
               }
            else

/* If all characters were sent OK echo that and then cut the buffer in half
   and remeber the last half for further echoing */

               printf ("multicast_echo: echoing: %d bytes %s", echostringlen, &echostring [0]);
            if (echostringlen > 3) /* 2 of these are the \n and \r */
               {
               x = echostringlen / 2 + (echostringlen % 2);
               y = echostringlen - x + 1;
               strncpy (msg, &echostring [x - 1], y);
               strncpy (&echostring [0], msg, y);
               echostring [y] = 0x0;
               echostringlen = y;
               }
            else                        /* not enough left to remember */
               echostringlen = 0;       /* so just zero the length */
         } /* if (recvBytes == -1 -- else */
      } /* if (FD_ISSET (socks0, &fdsetR)) -- else */
   } /* if (socksSelected > 0) */
else

/* nothing was ready for reading so we have a timeout */
  {

/* this is pretty much the same code as above. The difference is in the
   the strings output to the terminal. Following the program name are 2
   colon caracters instead of 1. This is not a typo. I make it a rule
   never to output the same message from more than 1 spot. that way it is
   always obvious where the message came from */

  if (socksSelected == 0)
     {
     if (echostringlen > 0)   
        {
        sendBytes = sendto (socks0, &echostring [0], echostringlen, 0, (struct sockaddr *) &multicast_addr, multicastlen);
        if (sendBytes != echostringlen)
           {
           if (sendBytes == -1)
              perror ("multicast_echo:: could send echo");
           else
              printf ("multicast_echo:: problem sending echo string only %d out of %d characters sent\n", sendBytes, echostringlen);
           }
        else
           printf ("multicast_echo:: echoing %d bytes %s", echostringlen, &echostring [0]);
        if (echostringlen > 3) /* 2 of these are the \n and \r */
           {
           x = echostringlen / 2 + (echostringlen % 2);
           y = echostringlen - x + 1;
           strncpy (msg, &echostring [x - 1], y);
           strncpy (&echostring [0], msg, y);
           echostring [y] = 0x0;
           echostringlen = y;
           }
        else
           echostringlen = 0;
        } /*   if (echostringlen > 0) */
     } /* if (socksSelect == 0) */
  else /* socksSelected must be < 0 some kind of error from select */
     perror ("multicast_echo: Unexpected error from select");
  } /* if (socksSelected > 0) -- else */

goto again;
}

