#define _POSIX_SOURCE

#include <sys/select.h>
#include <prototypes/inet_proto.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <c_utilities.h>

#define bzero(s, len)             memset((char *)(s), 0, len)

int errno;

main (argc, argv)
int    argc;
char   *argv [];

{
 short port_no;                    /* port to listen on - arg 1 */
 int   ka_timer;                   /* timer for keep alive - arg 2 */
 short delay;                      /* delay between echos in seconds - arg 3 */
 short lingertime = 0;             /* linger time in seconds - arg 4 */

typedef struct                     /* structure used to pass socket path */
 {                                 /* and peer name */
 short SocketIndex;
 char Pathname [67];
 char Peer [16];
 int Tries;
 } TYPEtransferMessage;

 TYPEtransferMessage transferMessage;


 short UDPsock;                    /* UDP socket used for interprocess comm */
 struct sockaddr_in interproc_addr;/* used for interprocess communication */

 int    nfds;                      /* max sock FD value, used in select */
 fd_set fdsetR;                    /* set of FDs to be tested by select */

 struct timeval timeout;           /* holds select timeout value */
 struct linger  linger1;           /* linger structure */
 int nodelay = 1;                  /* flag to control no delay setting */
 int reuse = 1;                    /* flag to control address reuse */
 int fcntl_flags;                  /* holds flags for fcntl function
                                      used to set non-blocking mode */
#define BUFFERLEN 100              /* how many bytes can we process at once */
 int socks0;                       /* socket to communicate with client */
 char echostring [BUFFERLEN];      /* array holding characters to be echoed */
 int echostringlen;                /* number of character in echostring */
 int oldechostringlen;             /* previous length of the string */

 short socksSelected;              /* number of sockets that select indicates
                                      are ready */

 int recvBytes, sendBytes;         /* number of bytes received and sent */
 char msg [103];                   /* temporary space for a string */

 short i, j, x, y;                 /* loop counters and temporaries */



 if (argc == 5)                    /* process the arguments. This is very */
    {                              /* simplestic argument processing, all */
    port_no = atoi (argv [1]);     /* arguments are required and are */
    ka_timer = atoi (argv [2]);    /* positional. But then again this */
    delay = atoi (argv [3]);       /* example is not about argument */
    lingertime = atoi (argv [4]);  /* processing */
    }
 else                              /* if we don't have all the arguments */
    {                              /* print out a usage message */
    printf ("\nUsage: stcp_echo <port_number> <keep_alive timer> <echo delay in seconds> <linger seconds>\n");
    printf ("\t\tport number should be 1 greater than the port number\n");
    printf ("\t\t\t used by transferring_echo\n");
    printf ("\t\tkeep_alive on/off  -- 0 off, anything else on\n");
    printf ("\t\tminimum delay 1, maximum delay is 15\n");
    printf ("\t\ta negative value for linger will cause it not to be set, 0 is valid\n");
    exit (-1);
    }

/* sanity check the values of the arguments. The max and min values are based
   on my view or reality, yours may be different
*/
 if (delay > 15)
    {
    printf ("%d is just too long a delay adjusting to 5\n", delay);
    delay = 5;
    }
 if (delay < 1) 
    {
    printf ("%d is just too short a delay adjusting to 5\n", delay);
    delay = 1;
    }
 if ((ka_timer < 120) && (ka_timer != 0))
    {
    printf ("%d is just too short a keep alive value adjusting to 120\n", ka_timer);
    ka_timer = 120;
    }
 if (ka_timer > 14400)
    {
    printf ("%d is just too large a keep alive value adjusting to 14400\n", ka_timer);
    ka_timer = 14400;
    }

 if (port_no < 1024)
    printf ("\nIf you are not privileged using port numbers below 1024 will not work\n\n");

/* Leting you know what argument values will actually be used */

 printf ("echo %d %d %d %d\n\n", port_no, ka_timer, delay, lingertime);

/* load the timeout struction based on the input delay value. This will be used
   by select. */

 timeout.tv_sec = delay;
 timeout.tv_usec = 0;


wait_for_server:

/* create a dgram socket */
 if ((UDPsock = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
    {
    perror ("receiving_echo: can't open dgram socket");
    exit (errno);
    }

/* Set SO_REUSEADDR so that we can have multiple instances */
 if (setsockopt (UDPsock, SOL_SOCKET, SO_REUSEADDR, (char *) &reuse, sizeof (reuse)) < 0)
   {
   perror ("receiving_echo: Error setting reuseaddr");
   exit (errno);
   }

/* bind to the port */
 bzero ( (char *) &interproc_addr, sizeof (interproc_addr));
 interproc_addr.sin_family        = AF_INET;
 interproc_addr.sin_addr.s_addr   = inet_addr ("127.0.0.1");
 interproc_addr.sin_port          = htons (port_no);

/* now bind to the address and port */
 if (bind (UDPsock, (struct sockaddr *) &interproc_addr, sizeof (interproc_addr)) < 0)
    {
    perror ("receiving_echo: can't bind to interproc address");
    exit (errno);
    }

/* now wait until we get something */
 if (recvfrom (UDPsock, (char *) &transferMessage, sizeof (transferMessage), 0, (struct sockaddr *) 0, 0) < 0)
    {
    perror ("receiving_echo: Error during recvfrom");
    exit (errno);
    }

/* receive the socket */
 socks0 = receive_socket (transferMessage.Pathname);
 if (socks0 < 0)
    {
    perror ("receiving_echo: receive_socket failed");
    exit (errno);
    }

/* send reply to server */
 interproc_addr.sin_port          = htons (port_no - 1);
 if (sendto (UDPsock, (char *) &transferMessage, sizeof (transferMessage), 0, (struct sockaddr *) &interproc_addr, sizeof (interproc_addr)) < 0)
    {
    perror ("receiving_echo:: sendto returned error");
    exit (errno);
    }

/* now close the UDP socket so we don't get another message from the server
   until we are ready. You may have noticed that there is a window here. If 
   the server gets another connection before we can close the UDP socket
   it will send it out and our socket will get it. Since we are not going to
   process it, it will be lost and the server will have to re-send out the
   path. At that point some other process will pick it up. */
 if (close (UDPsock) < 0)
    {
    perror ("receiving_echo: Error closing UDP socket");
    exit (errno);
    }

/* set a bunch of sock options */

/* Set SO_REUSEADDR so that I do not have to wait for an old socket in 
   TIMEWAIT state to be cleaned up before starting another server */

 if (setsockopt (socks0, SOL_SOCKET, SO_REUSEADDR, (char *) &reuse, sizeof (reuse)) < 0)
   {
   perror ("receiving_echo: Error setting reuseaddr");
   exit (errno);
   }

/* set the linger timer if its greater than -1. */

 if (lingertime > -1)
    {
    linger1.l_onoff = 1;
    linger1.l_linger = lingertime;
    if (setsockopt (socks0, SOL_SOCKET, SO_LINGER, (char *) &linger1, sizeof (linger1)) < 0)
       {
       perror ("receiving_echo: Error setting linger");
       exit (errno);
       }
    }

/* turn keep alive on so any connections that are left hanging can be cleaned
   up eventually. */

 if (ka_timer != 0)
    {
    linger1.l_onoff = 1;
    linger1.l_linger = ka_timer;
    if (setsockopt (socks0, SOL_SOCKET, SO_KEEPALIVE, (char *) &linger1, sizeof (linger1)) < 0)
      {
      perror ("receiving_echo: Error setting keepalive");
      exit (errno);
      }
    }

/* turn on no delay. This turns off the nagel algorithm so that we can send
   multiple small (less than MSS) packets without waiting for an ACK. */

 if (setsockopt (socks0, IPPROTO_TCP, TCP_NODELAY, (char *) &nodelay, sizeof (nodelay)) < 0)
    {
    perror ("receiving_echo: Error setting nodelay");
    exit (errno);
    }

/* set non-blocking mode on the socket. At the moment doing a get and ORing
   in the O_NDELAY value is probably overkill since the only flag supported 
   at this time is O_NDELAY. But things may change in the future so (as was
   explained to be in painful detail with graphic images of bits crashing
   togther) its best to do things right. */

 fcntl_flags = fcntl(socks0, F_GETFL, 0);
 if (fcntl_flags < 0)
    {
    perror ("receiving_echo: could not get the current fcntl flags for listening socket");
    exit (errno);
    }

 fcntl_flags = fcntl_flags | O_NDELAY;

 if (fcntl(socks0, F_SETFL, fcntl_flags) < 0)
    {
    perror ("receiving_echo: could not set non blocking IO for listening socket");
    exit (errno);
    }

/* record that we have something */
printf ("receiving_echo: received socket %s connected to %s\n", transferMessage.Pathname, transferMessage.Peer);

echostringlen = 0;
strcpy (echostring, "");

/* begining of main loop through the code, now things get complicated */

again:

/* reset the file descriptor array for select. This has to be done every time
   you go through select since select will modify this array

   Also find an array index that represents a socket that is not in use. The
   loop will find the last index instead of the first but it really doesn't matter */

FD_ZERO (&fdsetR);
FD_SET (socks0, &fdsetR);

/* Calculate the nfds value as the highest socket number plus 1. This is
   needed by select. */

nfds = socks0 + 1;

/* Do the select. We are only interested in reading and a timeout so the
   write and exception arguments are null */

socksSelected = select (nfds, &fdsetR, (fd_set *) 0, (fd_set *) 0, &timeout);

if (socksSelected < 0)
   {
   perror ("receiving_echo: select returned with an error, give up at this point");
   exit (errno);
   }

/* if select returns a value greater than 0 it represents the number of
   sockets ready (for reading in this case).  */

if (socksSelected > 0)
   {
   if (echostringlen > 2)                /* "remove" ending \n\r that */
      echostringlen = echostringlen - 2; /* were added */

/* receive bytes based on the number of bytes left in buffer. There will
   be bytes left in the buffer if we have not completed echoing the last
   string sent to us. We also need to leave room for the \n\r\0 that will be
   added to the end of the buffer. If there are more bytes in the receive
   queue then can fit in the buffer the next time select is called it will
   immediately indicate that the socket is ready for reading */

   recvBytes = recv (socks0, &echostring [echostringlen], BUFFERLEN - echostringlen - 3, 0);
   if (recvBytes == -1)  /* error during recv, clean up the socks */
      {                  /* and related arrays */
      sprintf (msg, "receiving_echo: Unexpected error while receiving on socket connected to %s", &transferMessage.Peer);
      perror (msg);
      close (socks0);
      socks0 = 0;
      }
   else                 /* no error on recv */
      {
      if (recvBytes == 0)  /* indicates connection was closed by peer */
         {
         printf ("receiving_echo: closing connection for %s\n", transferMessage.Peer);
         if (close (socks0) < 0)  /* close our socket */
            {
            sprintf (msg, "receiving_echo: error closing socket connected to %s", transferMessage.Peer);
            perror (msg);
            }
         socks0 = 0;     /* and clean up arrays */
         }
      else       /* we actually had bytes to read and we read them */
         {

/* adjust the number of bytes we have in the buffer to include what was just 
   read. Then add a \n\r\0 to it. The \n\r is needed so that when we echo
   the bytes we move the cursor down to the next line. Some clients, like
   telnet will not do that for the user. Without the \n\r the output becomes
   very strange. The \0 is needed so that %s in printf works correctly */

         oldechostringlen = echostringlen;
         echostringlen = echostringlen + recvBytes;
         echostring [echostringlen] = '\n';
         echostring [echostringlen + 1] = '\r';
         echostring [echostringlen + 2] = 0x0;
         echostringlen = echostringlen + 2;

/* now print the string but start from what was the end of the buffer so we 
   print only the bytes that were just received. */

         printf ("receiving_echo: received from %s: %d bytes %s", transferMessage.Peer, recvBytes, &echostring [oldechostringlen]);

/* now send the entire buffer, any old bytes and the new bytes */

         sendBytes = send (socks0, &echostring [0], echostringlen, 0);

/* if we didn't send all the bytes we had some kind of problem. Ideally at this
   point I could loop and try to send again or take some kind of exception
   problem. It is not strictly speaking an error. I choose just to report it.
   ALWAYS CHECK and take appropriate action, never assume that all characters
   were sent */

         if (sendBytes != echostringlen)
            printf ("receiving_echo: problem sending echo string to %s only %d out of %d characters sent\n", transferMessage.Peer, sendBytes, echostringlen);
         else

/* If all characters were sent OK echo that and then cut the buffer in half
   and remeber the last half for further echoing */

            printf ("receiving_echo: echoing to %s: %d bytes %s", transferMessage.Peer, echostringlen, echostring);
         if (echostringlen > 3) /* 2 of these are the \n and \r */
            {
            x = echostringlen / 2 + (echostringlen % 2);
            y = echostringlen - x + 1;
            strncpy (msg, &echostring [x - 1], y);
            strncpy (echostring, msg, y);
            echostring [y] = 0x0;
            echostringlen = y;
            }
         else                        /* not enough left to remember */
            echostringlen = 0;       /* so just zero the length */
         } /* if (recvBytes == 0) -- else */
      } /* if (recvBytes == -1 -- else */
   } /* if (socksSelected > 0) */
else

/* nothing was ready for reading so we have a timeout */
   {
   if (socksSelected == 0)
      {                /* if all we have is the listening socket we can */

/* this is pretty much the same code as above. The difference is in the
   the strings output to the terminal. Following the program name are 2
   colon caracters instead of 1. This is not a typo. I make it a rule
   never to output the same message from more than 1 spot. that way it is
   always obvious where the message came from */

      if (echostringlen > 0)   
         {
         sendBytes = send (socks0, echostring, echostringlen, 0);
         if (sendBytes != echostringlen)
            printf ("receiving_echo:: problem sending echo string to %s only %d out of %d characters sent\n", transferMessage.Peer, sendBytes, echostringlen);
         else
            printf ("receiving_echo:: echoing to %s: %d bytes %s", transferMessage.Peer, echostringlen, echostring);

         if (echostringlen > 3) /* 2 of these are the \n and \r */
            {
            x = echostringlen / 2 + (echostringlen % 2);
            y = echostringlen - x + 1;
            strncpy (msg, &echostring [x - 1], y);
            strncpy (echostring, msg, y);
            echostring [y] = 0x0;
            echostringlen = y;
            }
         else
            echostringlen = 0;
         }
      } /* socksSelected == 0 */
   else /* socksSelected must be < 0 some kind of error from select */
      perror ("receiving_echo: Unexpected error from select");
   } /* if (socksSelected > 0) -- else */

if (socks0 > 0)
   goto again;
else
   goto wait_for_server;

}

