#define _POSIX_SOURCE

#include <sys/select.h>
#include <prototypes/inet_proto.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <c_utilities.h>

#define bzero(s, len)             memset((char *)(s), 0, len)

int errno;

main (argc, argv)
int    argc;
char   *argv [];

{
 short port_no;                    /* port to listen on - arg 1 */
 short transfertime = 0;           /* how long to wait for transfer to
                                      complete ub seconds - arg 2 */

 struct sockaddr_in listening_addr;/* used to bind to IP address and port */
 struct sockaddr_in interproc_addr;/* used for interprocess communication */

 struct sockaddr_in cli_addr;      /* holds address of remote from accept */
 int    clilen;                    /* holds length of cli_addr structure) */
 int    nfds;                      /* max sock FD value, used in select */
 fd_set fdsetR;                    /* set of FDs to be tested by select */

 struct timeval timeout;           /* holds select timeout value */

 int reuse = 1;                    /* flag to control address reuse */
 int fcntl_flags;                  /* holds flags for fcntl function
                                      used to set non-blocking mode */
#define BUFFERLEN 100              /* how many bytes can we process at once */
#define MAXSOCKS 10                /* how many sockets can be handled */
 int socks [MAXSOCKS + 1];         /* array holding the socket FDs
                                      0 - listening socket
                                      1 - socket for interprocess communication
                                      2 - MAXSOCS - 1 - untransfered sockets
                                      MAXSOCKS - 1 extra to simplify some
                                          bounds chceking */
 char peer [MAXSOCKS][16];         /* array holding string containing IP
                                      address of remote peer for socker */

#define MAXTRANSFERTRIES 2         /* maximum number of transfer tried */
typedef struct                     /* structure used to pass socket path */
 {                                 /* and peer name */
 short SocketIndex;
 char Pathname [67];
 char Peer [16];
 int Tries;
 } TYPEtransferMessage;

TYPEtransferMessage transferMessage [MAXSOCKS];
TYPEtransferMessage transferMessage2;

 short freeSocks = 0;              /* a free entry in the socks array */
 char msg [103];                   /* temporary space for a string */
 char *peer_x;                     /* temporary space to hold the string
                                      containing peer;s IP address */
 short i, j, x, y;                 /* loop counters and temporaries */

 if (argc == 3)                    /* process the arguments. This is very */
    {                              /* simplestic argument processing, all */
    port_no = atoi (argv [1]);     /* arguments are required and are */
    transfertime = atoi (argv [2]);/* positional. But then again this */
                                   /* example is not about argument */
                                   /* processing */
    }
 else                              /* if we don't have all the arguments */
    {                              /* print out a usage message */
    printf ("\nUsage: stcp_transferring_echo <port_number> <transfer timeout in seconds>\n");
    exit (-1);
    }

/* sanity check the values of the arguments. The max and min values are based
   on my view or reality, yours may be different
*/
 if (transfertime < 1)
    {
    printf ("%d is just too small for a transfer timeout adjusting to 5\n", transfertime);
    transfertime = 5;
    }
 if (transfertime > 30)
    {
    printf ("%d is just too large for a transfer timeout adjusting to 5\n", transfertime);
    transfertime = 5;
    }

 if (port_no < 1024)
    printf ("\nIf you are not privileged using port numbers below 1024 will not work\n\n");

/* Leting you know what argument values will actually be used */

 printf ("transferring_echo %d %d\n\n", port_no, transfertime);

/* load the timeout struction based on the input delay value. This will be used
   by select. */

 timeout.tv_sec = transfertime;
 timeout.tv_usec = 0;

/* create a stream socket */
 if ((socks [0] = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
    perror ("transferring_echo: can't open stream socket");
    exit (errno);
    }

/* create UDP socket for interprocess communication */
 if ((socks [1] = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
    {
    perror ("transferring_echo: can't open UDP socket");
    exit (errno);
    }

/* set a bunch of sock options on what will become the listening socket.
   all these options will be inherited by the sockets created when a
   connection comes in and an accept is done */

/* Set SO_REUSEADDR so that I do not have to wait for an old socket in 
   TIMEWAIT state to be cleaned up before starting another server */

 if (setsockopt (socks [0], SOL_SOCKET, SO_REUSEADDR, (char *) &reuse, sizeof (reuse)) < 0)
   {
   perror ("transferring_echo: Error setting reuseaddr");
   exit (errno);
   }

/* build a sockaddr structure holding the address we will bind to. The IP
   address is INADDR_ANY meaning we will listen on all active IP addresses */

 bzero ( (char *) &listening_addr, sizeof (listening_addr));
 listening_addr.sin_family        = AF_INET;
 listening_addr.sin_addr.s_addr   = htonl (INADDR_ANY);
 listening_addr.sin_port          = htons (port_no);

/* now bind to the address and port */

 if (bind (socks [0], (struct sockaddr *) &listening_addr, sizeof (listening_addr)) < 0)
    {
    perror ("transferring_echo: can't bind to local listening address");
    exit (errno);
    }

/* set non-blocking mode on the socket. At the moment doing a get and ORing
   in the O_NDELAY value is probably overkill since the only flag supported 
   at this time is O_NDELAY. But things may change in the future so (as was
   explained to be in painful detail with graphic images of bits crashing
   togther) its best to do things right. */

 fcntl_flags = fcntl(socks [0], F_GETFL, 0);
 if (fcntl_flags < 0)
    {
    perror ("transferring_echo: could not get the current fcntl flags for listening socket");
    exit (errno);
    }

 fcntl_flags = fcntl_flags | O_NDELAY;

 if (fcntl(socks [0], F_SETFL, fcntl_flags) < 0)
    {
    perror ("transferring_echo: could not set non blocking IO for listening socket");
    exit (errno);
    }

/* build a sockaddr structure holding the address we use for inter process
   communication. The IP address is local_host meaning and it will be the same
   port that we are listening on */

 bzero ( (char *) &interproc_addr, sizeof (interproc_addr));
 interproc_addr.sin_family        = AF_INET;
 interproc_addr.sin_addr.s_addr   = inet_addr ("127.0.0.1");
 interproc_addr.sin_port          = htons (port_no);

/* now bind to the address and port */

 if (bind (socks [1], (struct sockaddr *) &interproc_addr, sizeof (interproc_addr)) < 0)
    {
    perror ("transferring_echo: can't bind to interproc address");
    exit (errno);
    }

/* Now that we have bound to the address that the receiving_echo processes will
   talk to us on we can change the structure so that it uses the port that we
   will use to talk to the receiving_echo processes on. The port number is
   plus 1 */

 interproc_addr.sin_port          = htons (port_no + 1);
 for (i = 2; i < MAXSOCKS; i++)
    socks [i] = 0;

/* listen for connections with a backlog of 5 */

 listen (socks [0], 5);

/* begining of main loop through the code, now things get complicated */

again:

/* reset the file descriptor array for select. This has to be done every time
   you go through select since select will modify this array

   we are only selecvting on two sockets, the one listening for client
   connections and the one used for interprocess communications */

for (freeSocks = 2; freeSocks <= MAXSOCKS ; freeSocks++)
    if (socks [freeSocks] == 0)
       break;

FD_ZERO (&fdsetR);
if (freeSocks < MAXSOCKS)       /* only select on the TCP socket if there */
   FD_SET (socks [0], &fdsetR); /* is a free slot to place the accepted */
FD_SET (socks [1], &fdsetR);    /* socket */

/* Calculate the nfds value as the highest socket number plus 1. This is
   needed by select. */

if (freeSocks < MAXSOCKS)
   nfds = ((socks [0] > socks [1]) ? socks [0] : socks [1]) + 1;
else
   nfds = socks [1] + 1;

/* Do the select. We are only interested in reading */

if (select (nfds, &fdsetR, (fd_set *) 0, (fd_set *) 0, &timeout) < 0)
   {
   perror ("transferring_echo: select returned with an error, give up at this point");
   exit (errno);
   }

/* check for interprocess communications first */
if (FD_ISSET (socks [1], &fdsetR))
   {
   if (recvfrom (socks [1], (char *) &transferMessage2, sizeof (transferMessage2), 0, (struct sockaddr *) 0, 0) < 0)
      {
      perror ("transferring_echo: Error during recvfrom");
      exit (errno);
      }
   freeSocks = transferMessage2.SocketIndex;
   if (close (socks [freeSocks]) < 0)
      {
      sprintf (msg, "transferring_echo: Error closing socket %d after transfer completed", freeSocks);
      perror (msg);
      }
   socks [freeSocks] = 0;
   transferMessage [freeSocks].Tries = 0;
   } /* if (FD_ISSET (socks [1], &fdsetR)) */
else
   {
   /* now check for an incomming connection */
   if (FD_ISSET (socks [0], &fdsetR))     /* the listening socket has */
      {                                   /* special handling */
      if (freeSocks < MAXSOCKS)           /* if there a free element in the */
         {                                /* socks array */
         clilen = sizeof (cli_addr);      /* this could be outside the loop */
                                          /* but I use it here so here it is */
         socks [freeSocks] = accept (socks [0], (struct sockaddr *) &cli_addr, &clilen);
         if (socks [freeSocks] < 0)       /* if accept returns < 0 we have */
            perror ("transferring_echo: accept error"); /* an error */
         else
            {
            peer_x = inet_ntoa (cli_addr.sin_addr);  /* get peers address */
            strcpy (&peer [freeSocks][0], peer_x);   /* and report it */
            printf ("Connection from %s\n", &peer [freeSocks][0]);
      
            strcpy (transferMessage [freeSocks].Peer, peer_x);
            if (transfer_socket (socks [freeSocks], transferMessage [freeSocks].Pathname) < 0)
               {
               perror ("transferring_echo: transfer_socket failed with error");
               exit (errno);
               }
   
            transferMessage [freeSocks].SocketIndex = freeSocks;
            if (sendto (socks [1], (char *) &transferMessage [freeSocks], sizeof (transferMessage [freeSocks]), 0, (struct sockaddr *) &interproc_addr, sizeof (interproc_addr)) < 0)
               perror ("transferring_echo: sendto returned error");
   
            transferMessage [freeSocks].Tries = 1;
   
            } /* if (freeSocks < MAXSOCKS)  -- else */
         } /* if (freeSocks < MAXSOCKS) */
      } /* if (FD_ISSET (socks [0], &fdsetR)) */
   else /* select timed out -- see if we have any sockets are being transfered */
      {
      for (i = 2; i < MAXSOCKS; i++) /* remember 0 is listening and 1 is */
          {                          /* is for interprocess communication */
          if (transferMessage [i].Tries > 0)     /* yes we do */
             {
             if (transferMessage [i].Tries < MAXTRANSFERTRIES) /* try again */
                {
                if (sendto (socks [1], (char *) &transferMessage [freeSocks],
                     sizeof (transferMessage [freeSocks]), 0,
                      (struct sockaddr *) &interproc_addr,
                       sizeof (interproc_addr)) < 0)
                   perror ("transferring_echo:: sendto returned error");
                transferMessage [i].Tries++;
                }
             else
                {
                printf ("transferring_echo: socket for connection to %s failed to be received - closing\n", &peer [i][0]);
                if (close (socks [i]) < 0)  /* close our socket */
                   perror ("transferring_echo: error closing socket");
                socks [i] = 0;
                peer [i][0] = 0x0;
                transferMessage [i].Tries = 0;
                }
             } /* if (transferMessage [i].Tries > 0) */
          } /* for (i = 2; i < MAXSOCKS; i++) */
      } /* if (FD_ISSET (socks [0], &fdsetR)) -- else */
   } /* /* if (FD_ISSET (socks [1], &fdsetR)) -- else */

goto again;
}

