#include <tcp_types.h>
#include <ioctl.h> 
#include <tcp_socket.h>
#include <in.h>
#include <stdio.h>
#include <stdlib>
#include <errno.h>
#include <error_codes.h>

#define bzero(s, len)             memset((char *)(s), 0, len)

void s$set_no_wait_mode(short int *,
                        long int *,
                        short int *);

void s$wait_event(short int *,
                  long int *,
                  long int *,
                  long int *,
                  short int *,
                  short int *);

void s$seq_read(short int *,
                short int *,
                short int *,
                char *,
                short int *);

int errno;

main (argc, argv)
int    argc;
char   *argv [];

{
 short port_no;                    /* port to send to - arg 1 */
 short port_no_2;                  /* port to receive on - arg 2 */

 struct sockaddr_in serv_addr;     /* used to hold server's IP address and 
                                      port */
 struct sockaddr_in my_addr;       /* used to hold my address and port */
 struct sockaddr_in recv_addr;     /* holds senders addr returned from
                                      recvfrom */
 int recvlen;                      /* length of recv_addr structure */

 int blocking = 0;                 /* flag to control nonblocking IO
                                      blocking = 0 means non-blocking */

#define BUFFERLEN 100              /* how many bytes can we process at once */
 int socks0;                       /* our socket */
 char echostring [BUFFERLEN];      /* array holding characters to be
                                      echoed */
 int echostringlen = BUFFERLEN;    /* max number of characters in echostring
                                      array */

 struct hostent *hostinfo;         /* pointer for structure allocated by
                                      gethostbyname */

 int recvBytes, sendBytes;         /* number of bytes sent and received */

 short socketReady = 0;            /* flag to indicate that socket is ready
                                      to be read */
 short int terminalReady = 1;      /* flag to indicate that the terminal is
                                      ready, i.e. something has been typed,
                                      it starts as ready so we can get a 
                                      caller_must_wait before calling
                                      s$wait_event */

 short int term_port = 5;          /* port ID of the terminal */
 short int return_code = 0;        /* return code for s$ calls */
 short num_events = 2;             /* number of events given to s$wait_event */
 short current_event = 1;          /* event causing s$wait_event to return */
 short int record_len;             /* bytes read from terminal */
 short int max_len = BUFFERLEN;    /* max bytes in buffer */
 long int timeout = -1;            /* timeout for s$wait_event (forever) */

#define SOCKETEVENT 1              /* array index for socket event */
#define TERMEVENT 0                /* array index for terminal event */
 long int events [2];              /* event array for s$wait_event */
 long int event_counts [2];        /* event counts for s$wait_event */


 if (argc == 4)                    /* process the arguments. This is very */
    {                              /* simplestic argument processing, all */
    port_no = atoi (argv [1]);     /* arguments are required and are */
    port_no_2 = atoi (argv [2]);   /* positional. But then again this */
                                   /* example is not about argument */
    }                              /* processing */
 else                              /* if we don't have all the arguments */
    {                              /* print out a usage message */
    printf ("\nUsage: tcpos_bc_echo_client <server port number> <receiving port number> <server name or IP address>\n");
    exit (-1);
    }

/* Leting you know what argument values will actually be used */

 printf ("bc_echo_client %d %d %s\n\n", port_no, port_no_2, argv [3]);

/* set up the terminal port to be in no-wait mode. This also sets the
   value for the terminal event. */

 s$set_no_wait_mode(&term_port, &events [TERMEVENT], &return_code);
 if (return_code != 0)
    {
    printf ("bc_echo_client: set_no_wait_mode failed with error code %d\n", return_code);
    exit (return_code);
    }
 event_counts [TERMEVENT] = -1;


/* create a stream socket */

 if ((socks0 = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
    {
    perror ("bc_echo_client: can't open dgram socket");
    exit (errno);
    }

/* set non-blocking mode on the socket */

 if (net_ioctl (socks0, FIONBIO, (char *) &blocking) < 0)     
    {
    perror ("bc_echo_client: could not set non blocking IO");
    exit (errno);
    }

/* get the event and event_count  associated with the socket */

   get_socket_event (socks0, &events [SOCKETEVENT], &event_counts [SOCKETEVENT]);

/* build my sock_addr so that I can bind to it */

 bzero ( (char *) &my_addr, sizeof (my_addr));
 my_addr.sin_family        = AF_INET;
 my_addr.sin_port          = htons (port_no_2);
 my_addr.sin_addr.s_addr   = htonl (INADDR_ANY);

 if (bind (socks0, (struct sockaddr *) &my_addr, sizeof (my_addr)) < 0)
    {
    perror ("bc_echo_client: can't bind local address");
    exit (errno);
    }

/* start building the sockaddr_in structure that will be used for sending
   to the server */

 bzero ( (char *) &serv_addr, sizeof (serv_addr));
 serv_addr.sin_family        = AF_INET;
 serv_addr.sin_port          = htons (port_no);

/* resolve the server name. Assume the argument is a host name, if not treat
   it as an IP address */

 hostinfo = gethostbyname (argv [3]);
 if (hostinfo == NULL)
    {
    printf ("\nCould not find address for host <%s>.\n", argv [3]);
    printf ("Will assume it is an IP address\n");
    serv_addr.sin_addr.s_addr = inet_addr (argv [3]);
    if (serv_addr.sin_addr.s_addr == INADDR_NONE)
       {
       printf ("It wasn't an IP address either\n");
       exit (-1);
       }
    }
 else
    serv_addr.sin_addr.s_addr = *(unsigned long *)(hostinfo -> h_addr_list [0]);
 endhostent ();

/* begining of main loop through the code */

again:

/* loop though both the socket and terminal while either is ready. Basically,
   keep going until we get e$caller_must_wait on both */

 while (socketReady || terminalReady)
       {
       if (socketReady)
          {
          recvlen = sizeof (recv_addr);
          recvBytes = recvfrom (socks0, echostring, BUFFERLEN - 1, 0, (struct sockaddr *) &recv_addr, &recvlen);
          if (recvBytes > 0)
             {
             socketReady = 1;             /* we have to go back and do this again */
             echostring [recvBytes] = 0;  /* set terminal null so printf will work */
             printf ("%s\n", echostring); /* write to terminal */
             }
          else
          if (recvBytes == -1)            /* error during recv, go ahead and exit */
             {                            /* except ignore call_must_waits */
             if (errno != e$caller_must_wait)
                {
                perror ("bc_echo_client: Unexpected error while receiving");
                exit (errno);
                }
             else
                socketReady = 0;
             } /* if (recvBytes == -1) */
          } /* if (socketReady */
      
          if (terminalReady)
             {
          s$seq_read (&term_port, &max_len, &record_len, echostring, &return_code);
          if (return_code != 0)           /* error during s$seq_read, go ahead and */
             {                            /* exit except ignore caller_must_wait */
             if (return_code != e$caller_must_wait)
                {
                printf ("bc_echo_client: unexpected error from s$seq_read %d\n", return_code);
                exit (return_code);
                }
             else
                terminalReady = 0;
             }
          else
             {
             echostringlen = record_len;  /* send all bytes we just read */
             sendBytes = sendto (socks0, echostring, echostringlen, 0, (struct sockaddr *) &serv_addr, sizeof (serv_addr));

/* if we fail to send all the bytes just report it. I should put in a loop 
   resend the data but I am being lazy. Also in this application it is very 
   unlikely that this condition will occur. */

             if (sendBytes != echostringlen)
                {
                if (sendBytes > 0)
                   printf ("bc_echo_client: only %d bytes out of %d sent\n", sendBytes, echostringlen);
                else /* if we are here we have an error */
                   {
                   perror ("bc_echo_client: unexpected error durning sendto");
                   exit (errno);
                   }
                }
             } /* if (return_code != 0) -- else */
          } /* if (terminalReady) ) */
      } /*  while (socketReady || terminalReady) */

/* Since we have gotten an e$caller_must_wait from both events we can now do
   an s$wait_event */

 s$wait_event (&num_events, events, event_counts, &timeout, &current_event, &return_code);
 if (return_code != 0)
    {
    printf ("bc_echo_client: s$wait_event returned %d\n", return_code);
    exit (return_code);
    }
 if (current_event == 1)
    terminalReady = 1;
 else
    socketReady = 1;
    
goto again;
}

