#include <tcp_types.h>
#include <ioctl.h> 
#include <tcp_socket.h>
#include <in.h>
#include <stdio.h>
#include <stdlib>
#include <errno.h>
#include <error_codes.h>

#define bzero(s, len)             memset((char *)(s), 0, len)

int errno;

main (argc, argv)
int    argc;
char   *argv [];

{
 short port_no;                    /* port to listen on - arg 1 */
 short port_no_2;                  /* port number to broadcast on arg 2 */
 short delay;                      /* delay between echos in seconds - arg 3 */
 int   recvbuf = 0;                /* receive buffer size in bytes - arg 4 */
 int   sendbuf = 0;                /* send byffer size in bytes - arg 5 */

 struct sockaddr_in serv_addr;     /* used to bind to IP address and port */
 struct sockaddr_in cli_addr;      /* holds address of remote from accept */
 int    clilen;                    /* holds length of cli_addr structure) */
 struct sockaddr_in broadcast_addr;/* holds the broadcast address */
 int    broadcastlen;              /* hold length of the broadcast_addr */
 int    nfds;                      /* max sock FD value, used in select */
 fd_set fdsetR;                    /* set of FDs to be tested by select */

 struct timeval timeout;           /* holds select timeout value */
 int blocking = 0;                 /* flag to control nonblocking IO */
 int allow_broadcast = 1;          /* flag to control the use of broadcast
                                      address */
#define BUFFERLEN 1000             /* how many bytes can we process at once */
 int socks0;                       /* array holding the socket FDs */
 char peer[16];                    /* array holding string containing IP
                                      address of remote peer for socker */
 char echostring [BUFFERLEN];      /* array holding characters to be echoed */
 int echostringlen;                /* array holding number of character in
                                      echostring array */

 short socksSelected;              /* number of sockets that select indicates
                                      are ready */

 int recvBytes, sendBytes;         /* number of bytes received and sent */
 char msg [257];                   /* temporary space for a string */
 char *peer_x;                     /* temporary space to hold the string
                                      containing peer's IP address */
 int savedErrno;                   /* temporary to save last errno */
 short i, j, x, y;                 /* loop counters and temporaries */

 FILE *outFile;                    /* outfile for messages */

 if (argc == 6)                    /* process the arguments. This is very */
    {                              /* simplestic argument processing, all */
    port_no = atoi (argv [1]);     /* positional. But then again this */
    port_no_2 = atoi (argv [2]);   /* example is not about argument */
    delay = atoi (argv [3]);       /* processing */
    recvbuf = atoi (argv [4]);
    sendbuf = atoi (argv [5]);
    }
 else                              /* if we don't have all the arguments */
    {                              /* print out a usage message */
    printf ("\nUsage: tcpos_broadcast_echo <listening port number> <sending port number> <echo delay in seconds> <receive buffer size> <send buffer size>\n");
    printf ("\t\tminimum delay 1, maximum delay is 15\n");
    printf ("\t\ta value of 0 for the receive/send buffers will cause these options not to be set\n");
    exit (-1);
    }

/* sanity check the values of the arguments. The max and min values are based
   on my view or reality, yours may be different
*/
 if (delay > 15)
    {
    printf ("%d is just too long a delay adjusting to 5\n");
    delay = 5;
    }
 if (delay < 1) 
    {
    printf ("%d is just too short a delay adjusting to 1\n", delay);
    delay = 1;
    }
 if (recvbuf > 64000)
    {
    printf ("%d is just too large a receive buffer, changing to 32000\n", recvbuf);
    recvbuf = 32000;
    }
 if ((recvbuf < 5000) && (recvbuf != 0))
    {
    printf ("%d is just too small a receive buffer, changing to 5000\n", recvbuf);
    recvbuf = 5000;
    }
 if (sendbuf > 64000)
    {
    printf ("%d is just too large a send buffer, changing to 32000\n", sendbuf);
    sendbuf = 32000;
    }
 if ((sendbuf < 5000) && (sendbuf != 0))
    {
    printf ("%d is just too small a send buffer, changing to 5000\n", sendbuf);
    sendbuf = 5000;
    }

 if (port_no == port_no_2)
    {
    printf ("hang on to your hat. Broadcasting to the same port that you\n");
    printf ("are listening on will create a feed back loop\n\n");
    }

/* Leting you know what argument values will actually be used */

 printf ("broadcast_echo %d %d %d %d %d\n", port_no, port_no_2, delay, recvbuf, sendbuf);

/* load the timeout structure based on the input delay value. This will be used
   by select. */

 timeout.tv_sec = delay;
 timeout.tv_usec = 0;

/* create a stream socket */

 if ((socks0 = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
    {
    perror ("broadcast_echo: can't open dgram socket");
    exit (errno);
    }

/* set a bunch of sock options */

/* change the size of the send and receive buffers. This is probably overkill
   for this program but it provides an example of how to do it */

 if (recvbuf != 0)
    {
    if (setsockopt (socks0, SOL_SOCKET, SO_RCVBUF, (char *) &recvbuf, sizeof (recvbuf)) < 0)
       {
       perror ("broadcast_echo: Error setting receive buffer size");
       exit (errno);
       }
    }

 if (sendbuf != 0)
    {
    if (setsockopt (socks0, SOL_SOCKET, SO_SNDBUF, (char *) &sendbuf, sizeof (sendbuf)) < 0)
       {
       perror ("broadcast_echo: Error setting send buffer size");
       exit (errno);
       }
    }

/* set non-bocking IO */

 if (net_ioctl (socks0, FIONBIO, (char *) &blocking) < 0)     
    {
    perror ("broadcast_echo: could not set non blocking IO");
    exit (errno);
    }

/* You also need to set SO_BROADCAST so that you can send to the broadcast
   address. If you don't set this you get an e$insufficient_access error (1141)
   "Not enough access to perform operation." */

 allow_broadcast = 1;
 if (setsockopt (socks0, SOL_SOCKET, SO_BROADCAST, (char *) &allow_broadcast, sizeof (allow_broadcast)) < 0)
    {
    printf ("broadcast_echo: Error setting send buffer size %d\n", errno);
    exit (errno);
    }

/* build a sockaddr structure holding the address we will bind to. The IP
   address is INADDR_ANY meaning we will listen on all active IP addresses */

 bzero ( (char *) &serv_addr, sizeof (serv_addr));
 serv_addr.sin_family        = AF_INET;
 serv_addr.sin_addr.s_addr   = htonl (INADDR_ANY);
 serv_addr.sin_port          = htons (port_no);

/* now bind to the address and port */

 if (bind (socks0, (struct sockaddr *) &serv_addr, sizeof (serv_addr)) < 0)
    {
    perror ("broadcast_echo: can't bind local address");
    exit (errno);
    }

/* create a sockaddr structure holding the broadcast address. */ 

 bzero ( (char *) &broadcast_addr, sizeof (broadcast_addr));
 broadcast_addr.sin_family        = AF_INET;
 broadcast_addr.sin_addr.s_addr   = htonl (INADDR_BROADCAST);
 broadcast_addr.sin_port          = htons (port_no_2);

 broadcastlen = sizeof (broadcast_addr);

again:

/* reset the file descriptor array for select. This has to be done every time
   you go through select since select will modify this array */

FD_ZERO (&fdsetR);
FD_SET (socks0, &fdsetR);
nfds = socks0 + 1;

/* Do the select. We are only interested in reading and a timeout so the
   write and exception arguments are null */

socksSelected = select (nfds, &fdsetR, (fd_set *) 0, (fd_set *) 0, &timeout);

/* if select returns a value greater than 0 it indicates that the socket
   is ready for reading. */

if (socksSelected > 0)
   {
   if (!FD_ISSET (socks0, &fdsetR))        /* just a sanity check since */
      {                                    /* there is only 1 socket */
                                           /* this should always be true */
      printf ("broadcast_echo: select returned a socket we didn't expect\n");
      exit (-1);
      }
   else
      { 
      if (echostringlen > 2)                 /* "remove" ending \n\r that */
          echostringlen = echostringlen - 2; /* were added */

/* receive bytes based on the number of bytes left in buffer. There will
   be bytes left in the buffer if we have not completed echoing the last
   string sent to us. We also need to leave room for the \n\r\0 that will be
   added to the end of the buffer. If there are more bytes in the receive
   queue then can fit in the buffer the next time select is called it will
   immediately indicate that the socket is ready for reading */

      clilen = sizeof (cli_addr);     /* who are they from */
      recvBytes = recvfrom (socks0, &echostring[echostringlen], BUFFERLEN - echostringlen - 3, 0, (struct sockaddr *) &cli_addr, &clilen);
      if (recvBytes == -1)  /* error during recv, clean up the socks */
         {                  /* and related arrays */
         if (errno != e$caller_must_wait) /* ignore caller must wait errors */
            {
            perror ("broadcast_echo: Unexpected error while receiving");
            exit (errno);
            }
         }
      else                 /* no error on recv */
         {
         peer_x = inet_ntoa (cli_addr.sin_addr);
         strcpy (peer, peer_x);

/* adjust the number of bytes we have in the buffer to include what was just 
   read. Then add a \n\r\0 to it. The \n\r is needed so that when we echo
   the bytes we move the cursor down to the next line. Some clients 
   will not do that for use. Without the \n\r the output becomes
   very strange. The \0 is needed so that %s in printf works correctly */

         echostringlen = echostringlen + recvBytes;
         echostring [echostringlen] = '\n';
         echostring [echostringlen + 1] = '\r';
         echostring [echostringlen + 2] = 0x0;
         echostringlen = echostringlen + 2;

/* now print the string but start from what was the end of the buffer so we 
   print only the bytes that were just received. */

            printf ("broadcast_echo: received from %s: %d bytes %s\n", peer, recvBytes, &echostring [echostringlen - recvBytes - 2]);

/* now send the entire buffer, any old bytes and the new bytes */

            sendBytes = sendto (socks0, &echostring [0], echostringlen, 0, (struct sockaddr *) &broadcast_addr, broadcastlen);

/* if we needed send all the bytes we had some kind of problem. Ideally at this
   point I could loop and try to send again or take some kind of exception
   problem. It is not strictly speaking an error. I choose just to report it.
   ALWAYS CHECK and take appropriate action, never assume that all characters
   were sent */

            if (sendBytes != echostringlen)
               {
               if (sendBytes == -1)
                  perror ("broadcast_echo: could send echo");
               else
                  printf ("broadcast_echo: problem sending echo string only %d out of %d characters sent\n", sendBytes, echostringlen);
               }
            else

/* If all characters were sent OK echo that and then cut the buffer in half
   and remeber the last half for further echoing */

               printf ("broadcast_echo: echoing: %d bytes %s", echostringlen, &echostring [0]);
            if (echostringlen > 3) /* 2 of these are the \n and \r */
               {
               x = echostringlen / 2 + (echostringlen % 2);
               y = echostringlen - x + 1;
               strncpy (msg, &echostring [x - 1], y);
               strncpy (&echostring [0], msg, y);
               echostring [y] = 0x0;
               echostringlen = y;
               }
            else                        /* not enough left to remember */
               echostringlen = 0;       /* so just zero the length */
         } /* if (recvBytes == -1 -- else */
      } /* if (FD_ISSET (socks0, &fdsetR)) -- else */
   } /* if (socksSelected > 0) */
else

/* nothing was ready for reading so we have a timeout */
  {

/* this is pretty much the same code as above. The difference is in the
   the strings output to the terminal. Following the program name are 2
   colon caracters instead of 1. This is not a typo. I make it a rule
   never to output the same message from more than 1 spot. that way it is
   always obvious where the message came from */

  if (socksSelected == 0)
     {
     if (echostringlen > 0)   
        {
        sendBytes = sendto (socks0, &echostring [0], echostringlen, 0, (struct sockaddr *) &broadcast_addr, broadcastlen);
        if (sendBytes != echostringlen)
           {
           if (sendBytes == -1)
              perror ("broadcast_echo:: could send echo");
           else
              printf ("broadcast_echo:: problem sending echo string only %d out of %d characters sent\n", sendBytes, echostringlen);
           }
        else
           printf ("broadcast_echo:: echoing %d bytes %s", echostringlen, &echostring [0]);
        if (echostringlen > 3) /* 2 of these are the \n and \r */
           {
           x = echostringlen / 2 + (echostringlen % 2);
           y = echostringlen - x + 1;
           strncpy (msg, &echostring [x - 1], y);
           strncpy (&echostring [0], msg, y);
           echostring [y] = 0x0;
           echostringlen = y;
           }
        else
           echostringlen = 0;
        } /*   if (echostringlen > 0) */
     } /* if (socksSelect == 0) */
  else /* socksSelected must be < 0 some kind of error from select */
     perror ("broadcast_echo: Unexpected error from select");
  } /* if (socksSelected > 0) -- else */

goto again;
}

