#include <stdlib.h>

ext_shared short port_no;                    /* port to listen on - arg 1 */
ext_shared int   ka_onoff;                   /* flag for keep alive - arg 2*/
ext_shared short delay;                      /* delay between echos in seconds - arg 3 */
ext_shared short lingertime = 0;             /* linger time in seconds - arg 4 */
ext_shared int   recvbuf = 0;                /* receive buffer size in bytes - arg 5 */
ext_shared int   sendbuf = 0;                /* send byffer size in bytes -arg 6*/

ext_shared char output_path [256];           /* something to hold path of PM */

void s$get_port_attachment(short int *,
                           char_varying (256) *,
                           char_varying (32) *,
                           short int *,
                           short int *,
                           short int *,
                           short int *,
                           short int *);

main (argc, argv)
int    argc;
char   *argv [];

{
short int port_id = 5;                       /* port ID of the terminal */
char_varying (32) entry_name = "echo_task";  /* name of the entry that will
                                                perform the "task" */
short int debug_sw = 0;                      /* debug switch - no debug */
short int return_code;                       /* standard VOS return code */
char_varying (256) path_name;                /* pathname of terminal */
short int i;                                 /* temporary */

char_varying (32) port_name;                 /* these are various output */
short int log_port_id;                       /* variables that I don't use */
short int type;                              /* but need to declare */
short int io_type;
short int access_mode;

 if (argc == 7)                    /* process the arguments. This is very */
    {                              /* simplestic argument processing, all */
    port_no = atoi (argv [1]);     /* arguments are required and are */
    ka_onoff = atoi (argv [2]);    /* positional. But then again this */
    delay = atoi (argv [3]);       /* example is not about argument */
    lingertime = atoi (argv [4]);  /* processing */
    recvbuf = atoi (argv [5]);
    sendbuf = atoi (argv [6]);
    }
 else                              /* if we don't have all the arguments */
    {                              /* print out a usage message */
    printf ("\nUsage: tcpos_tasking_echo <port_number> <keep_alive on/off> <echo delay in seconds> <linger seconds> <receive buffer size> <send buffer size>\n");
    printf ("\t\tkeep_alive on/off  -- 0 off, anything else on\n");
    printf ("\t\tminimum delay 1, maximum delay is 15\n");
    printf ("\t\ta value of 0 for linger, or the receive/send buffers will cause these options not to be set\n");
    exit (-1);
    }

/* save the directory that the PM is in, this will be where the out files
   for each task go */

 strncpy (output_path, argv [0], strlen (argv [0]) - 21); /* strip off PM name */

/* sanity check the values of the arguments. The max and min values are based
   on my view or reality, yours may be different
*/
 if (delay > 15)
    {
    printf ("%d is just too long a delay adjusting to 5\n");
    delay = 5;
    }
 if (delay < 1) 
    {
    printf ("%d is just too short a delay adjusting to 1\n", delay);
    delay = 1;
    }
 if (recvbuf > 64000)
    {
    printf ("%d is just too large a receive buffer, changing to 32000\n");
    recvbuf = 32000;
    }
 if ((recvbuf < 5000) && (recvbuf != 0))
    {
    printf ("%d is just too small a receive buffer, changing to 5000\n");
    recvbuf = 5000;
    }
 if (sendbuf > 64000)
    {
    printf ("%d is just too large a send buffer, changing to 32000\n");
    sendbuf = 32000;
    }
 if ((sendbuf < 5000) && (sendbuf != 0))
    {
    printf ("%d is just too small a send buffer, changing to 5000\n");
    sendbuf = 5000;
    }

 if (port_no < 1024)
    printf ("\nIf you are not privileged using port numbers below 1024 will not work\n\n");

/* Leting you know what argument values will actually be used */

 printf ("tasking_echo %d %d %d %d %d %d\n\n", port_no, ka_onoff, delay, lingertime, recvbuf, sendbuf);

/* get the path to the terminal so we can give it to the tasks */

s$get_port_attachment (&port_id, &path_name, &port_name, &log_port_id, &type, &io_type, &access_mode, &return_code);
if (return_code != 0)
   {
   printf ("tasking_echo: Error from s$get_port_attachment: %d\n", return_code);
   exit (return_code);
   }

/* start up the echo tasks */

for (i = 2; i < 12; i++)
    {
    s$init_task (&i, &path_name, &return_code);
    if (return_code != 0)
       {
       printf ("tasking_echo: Could not init task %d, error %d\n", i, return_code);
       exit (return_code);
       }
    s$start_task (&i, &entry_name, &debug_sw, &return_code);
    if (return_code != 0)
       {
       printf ("tasking_echo: Could not start task %d, error %d\n", i, return_code);
       exit (return_code);
       }
    } /* for (i = 1; i < 11; i++) */

/* sleep forever, well wake up every 5 minutes just to do something.

   Note that this is really a very bad tasking program. It doesn't recover if
   a task fails. However, its purpose is not to demonstate tasking but to
   run TCP connections in a task so I wanted the simplest tasking program
   I could create. */

while (1)
      sleep (300);

}
